% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Beta}
\alias{Beta}
\alias{dBeta}
\alias{eBeta}
\alias{ebeta}
\alias{iBeta}
\alias{ibeta}
\alias{lBeta}
\alias{lbeta}
\alias{pBeta}
\alias{qBeta}
\alias{rBeta}
\alias{sBeta}
\alias{sbeta}
\title{The standard Beta Distribution.}
\usage{
dBeta(x, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

pBeta(q, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

qBeta(p, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

rBeta(n, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

eBeta(X, w, method = "MOM")

ebeta(X, w, method = "MOM")

lBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2),
  logL = TRUE)

sBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

iBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

lbeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

sbeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

ibeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2))
}
\arguments{
\item{params}{a list includes all parameters}

\item{x,q}{vector of quantiles.}

\item{w}{weights of sample.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{shape1,shape2}{shape parameters.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lBeta gives log likelihood.}

\item{...}{other parameters}
}
\value{
dBeta gives the density; pBeta gives the distribution function;
qBeta gives the quantile function; rBeta generates random variables;
eBeta estimate the parameters; sBeta gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Beta distribution
}
\details{
\itemize{
 \item{Probability density function:}
 \deqn{f(x) = \frac{x^{\alpha-1}(1-x)^{\beta-1}} {\mathcal{B}(\alpha,\beta)}}
 with \eqn{\alpha} and \eqn{\beta} two shape parameters and \eqn{\mathcal B} beta function
 \item{Cumulative distribution function:}
 \deqn{F(x) = \frac{\int_{0}^{x} y^{\alpha-1}(1-y)^{\beta-1}dy} {\mathcal{B}(\alpha,\beta)}
 =\mathcal{B}(x; \alpha,\beta)} with \eqn{\mathcal B (x; \alpha,\beta)} being incomplete beta function.
 \item{Log-likelihood function:}
 \deqn{L(\alpha,\beta;X)=\sum_i\left[ (\alpha-1)\ln(x)+(\beta-1)\ln(1-x)-\ln \mathcal{B}(\alpha,\beta) \right]}
 \item{Score function vector:}
 \deqn{V(\mu,\sigma;X)
 =\left( \begin{array}{c}
 \frac{\partial L}{\partial \alpha}  \\
 \frac{\partial L}{\partial \beta}
 \end{array} \right)
 =\sum_i
 \left( \begin{array}{c}
 \psi^{(0)}(\alpha+\beta)-\psi^{(0)}(\alpha)+\ln(x) \\
 \psi^{(0)}(\alpha+\beta)-\psi^{(0)}(\beta)+\ln(x)
 \end{array} \right)
 }
 with \eqn{\psi^{(0)}} being log-gamma function.
 \item{Observed information matrix:}
 \deqn{\mathcal J (\mu,\sigma;X)=
 \left( \begin{array}{cc}
 \psi^{(1)}(\alpha)-\psi^{(1)}(\alpha+\beta) & -\psi^{(1)}(\alpha+\beta) \\
 -\psi^{(1)}(\alpha+\beta) & \psi^{(1)}(\beta)-\psi^{(1)}(\alpha+\beta) \end{array} \right)
 }
 with \eqn{\psi^{(1)}} being digamma function.
}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
shape1 <- 1
shape2 <- 2
X <- rBeta(n, shape1, shape2)
(est.par <- eBeta(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dBeta(den.x,shape1=est.par$shape1,shape2=est.par$shape2)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qBeta((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot", xlab="Theoretical Quantiles",
ylab="Sample Quantiles", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

plot((1:n-0.5)/n, pBeta(sort(X), params=est.par), main="P-P Plot", xlab="Theoretical Percentile",
ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape1=1, shape2=2)
X <- rBeta(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eBeta(X,w) # estimated parameters of weighted sample
eBeta(X) # estimated parameters of unweighted sample

# Alternative parameter estimation methods
(est.par <- eBeta(X, method = "numerical.MLE"))

# Extracting shape parameters
est.par[attr(est.par,"par.type")=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rBeta,edist=eBeta,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5), method ="numerical.MLE")
eval.estimation(rdist=rBeta,edist=eBeta,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5), method ="MOM")

# evaluate the precision of estimation by Hessian matrix
X <- rBeta(1000, shape1, shape2)
(est.par <- eBeta(X))
H <- attr(eBeta(X, method = "numerical.MLE"),"nll.hessian")
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lBeta(X,param = est.par)
lBeta(X,param = est.par, logL=FALSE)
sBeta(X,param = est.par)
iBeta(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

