% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Burr}
\alias{Burr}
\alias{dBurr}
\alias{eBurr}
\alias{lBurr}
\alias{pBurr}
\alias{qBurr}
\alias{rBurr}
\title{The Burr's Distribution.}
\usage{
dBurr(x, b = 1, g = 2, s = 2, params = list(b = 1, g = 2, s = 2))

pBurr(q, b = 1, g = 2, s = 2, params = list(b = 1, g = 2, s = 2))

qBurr(p, b = 1, g = 2, s = 2, params = list(b = 1, g = 2, s = 2))

rBurr(n, b = 1, g = 2, s = 2, params = list(b = 1, g = 2, s = 2))

eBurr(X, w, method = "numerical.MLE")

lBurr(X, w, b = 1, g = 2, s = 2, params = list(b = 1, g = 2, s = 2),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{b}{scale parameters.}

\item{g,s}{shape parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lBurr gives log likelihood.}

\item{...}{other parameters}
}
\value{
dBurr gives the density; pBurr gives the distribution function;
qBurr gives the quantile function; rBurr generates random variables;
eBurr estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Burr distribution
}
\details{
Burr's Distribution

See \href{../doc/Distributions-Burr.html}{Distributions-Burr}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
b = 1; g = 2; s = 2
X <- rBurr(n, b = 1, g = 2, s = 2)
(est.par <- eBurr(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dBurr(den.x, b=est.par$b, g=est.par$g, s=est.par$s)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qBurr((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(0,5), ylim = c(0,5))
abline(0,1)

plot((1:n-0.5)/n, pBurr(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(b=1, g=2, s =2)
X <- rBurr(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eBurr(X,w) # estimated parameters of weighted sample
eBurr(X) # estimated parameters of unweighted sample

# Extracting shape or scale parameters
est.par[attributes(est.par)$par.type=="scale"]
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rBurr,edist=eBurr,n = 1000, rep.num = 1e3, params = list(b=1, g=2, s =2))

# evaluate the precision of estimation by Hessian matrix
X <- rBurr(1000, b = 1, g = 2, s = 2)
(est.par <- eBurr(X))
H <- attributes(eBurr(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lBurr(X,param = est.par)
lBurr(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

