% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExplodeLayoutBasic.R
\name{plot_binet_ggplot2}
\alias{plot_binet_ggplot2}
\title{Plot bipartite network given node list (label, coordinates, shape, color) and incidence matrix.}
\usage{
plot_binet_ggplot2(nodelist, incidence_matrix)
}
\arguments{
\item{nodelist}{A dataframe of at least 5 columns: Label, X, Y, Color, baseShape.}

\item{incidence_matrix}{A matrix where row names and column names are the node ID of a bipartite network. An element of the i-th row and j-th column of the matrix is 0 if node on row i is not connected to node on column j, and edge weight if they are connected.}
}
\value{
a ggplot2 object p which can be shown using print(p).
}
\description{
Plot bipartite network given node list (label, coordinates, shape, color) and incidence matrix.
}
\examples{
exploded_nodelist=get_explode_nodelist(example_nodelist,radius=1.2)
p=plot_binet_ggplot2(exploded_nodelist,example_incidmat)
print(p)
}
