% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikelihoodApproximation.R
\name{computeConfidenceInterval}
\alias{computeConfidenceInterval}
\title{Compute the point estimate and confidence interval given a likelihood function approximation}
\usage{
computeConfidenceInterval(approximation, alpha = 0.05)
}
\arguments{
\item{approximation}{An approximation of the likelihood function as fitted using the
\code{\link[=approximateLikelihood]{approximateLikelihood()}} function.}

\item{alpha}{The alpha (expected type I error).}
}
\value{
A data frame containing the point estimate, and upper and lower bound of the confidence interval.
}
\description{
Compute the point estimate and confidence interval given a likelihood function approximation
}
\details{
Compute the point estimate and confidence interval given a likelihood function approximation.
}
\examples{
# Simulate some data for this example:
populations <- simulatePopulations()

cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
                                          data = populations[[1]],
                                          modelType = "cox")
cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
approximation <- approximateLikelihood(cyclopsFit, "x")
computeConfidenceInterval(approximation)

}
