% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVCApplicationInput.R
\name{AVCApplicationInput}
\alias{AVCApplicationInput}
\title{Abnormal Volume Calculation Parameters}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
a ESTParameters R6 object
}
\description{
This R6 class defines the parameters for the Abnormal Volume Event Study. 
We recommend to use the \code{set} functionality to setup your Event Study, 
as we check input parameters.

For more details see the help vignette:
\code{vignette("parameters_eventstudy", package = "EventStudy")}
}
\section{Methods}{

\describe{
  \item{\code{$new()}}{Constructor for AVCApplicationInput}
  \item{\code{$setEMail(eMail)}}{Set the e-Mail address for reporting. This 
  functionality is currently not working}
  \item{\code{$setBenchmarkModel(model = 'mm')}}{Setter for the benchmark
  models}
  \item{\code{$setReturnType(returnType)}}{Setter for the return type (log 
  or simple)}
  \item{\code{$setTestStatistics(testStatistics)}}{Setter for the test 
  statistics}
}
}

\section{Arguments}{

\describe{
 \item{AVCApplicationInput}{An \code{AVCApplicationInput} object}
 \item{eMail}{An E-Mail address in \code{String} format}
 \item{model}{A benchmark model in \code{String} format}
 \item{returnType}{A return type in \code{String} format}
 \item{testStatistics}{A \code{String} vector with test statistics}
}
}

\examples{
\dontrun{
# get files for our S&P500 example; 3 files are written in the current 
# working directory
getSP500ExampleFiles()

# Generate a new parameter object
avcParams <- AVCApplicationInput$new()

# set test statistics
arcParams$setBenchmarkModel("garch")

# Setup API object
apiKey <- "{Your API key}"
estSetup <- EventStudyAPI$new()
estSetup$authentication(apiKey)

# Perform Event Study
estSetup$performEventStudy(estParams = avcParams, 
                           dataFiles = c("request_file" = "01_RequestFile.csv",
                                         "firm_data"    = "02_firmData.csv",
                                         "market_data"  = "03_marketData.csv"))

# Download task results and save them in the actiual working directory
estSetup$getTaskResults()
}

}
\section{Super classes}{
\code{\link[EventStudy:ApplicationInputInterface]{EventStudy::ApplicationInputInterface}} -> \code{\link[EventStudy:EventStudyApplicationInput]{EventStudy::EventStudyApplicationInput}} -> \code{AVCApplicationInput}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-setEMail}{\code{AVCApplicationInput$setEMail()}}
\item \href{#method-setBenchmarkModel}{\code{AVCApplicationInput$setBenchmarkModel()}}
\item \href{#method-setReturnType}{\code{AVCApplicationInput$setReturnType()}}
\item \href{#method-setNonTradingDays}{\code{AVCApplicationInput$setNonTradingDays()}}
\item \href{#method-setTestStatistics}{\code{AVCApplicationInput$setTestStatistics()}}
\item \href{#method-setDataFiles}{\code{AVCApplicationInput$setDataFiles()}}
\item \href{#method-clone}{\code{AVCApplicationInput$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="serialize">}\href{../../EventStudy/html/ApplicationInputInterface.html#method-serialize}{\code{EventStudy::ApplicationInputInterface$serialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="serializeToJson">}\href{../../EventStudy/html/ApplicationInputInterface.html#method-serializeToJson}{\code{EventStudy::ApplicationInputInterface$serializeToJson()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="setNamedList">}\href{../../EventStudy/html/ApplicationInputInterface.html#method-setNamedList}{\code{EventStudy::ApplicationInputInterface$setNamedList()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="setResultFileType">}\href{../../EventStudy/html/ApplicationInputInterface.html#method-setResultFileType}{\code{EventStudy::ApplicationInputInterface$setResultFileType()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="EventStudy" data-topic="EventStudyApplicationInput" data-id="setup">}\href{../../EventStudy/html/EventStudyApplicationInput.html#method-setup}{\code{EventStudy::EventStudyApplicationInput$setup()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setEMail"></a>}}
\if{latex}{\out{\hypertarget{method-setEMail}{}}}
\subsection{Method \code{setEMail()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$setEMail(eMail)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setBenchmarkModel"></a>}}
\if{latex}{\out{\hypertarget{method-setBenchmarkModel}{}}}
\subsection{Method \code{setBenchmarkModel()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$setBenchmarkModel(model)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setReturnType"></a>}}
\if{latex}{\out{\hypertarget{method-setReturnType}{}}}
\subsection{Method \code{setReturnType()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$setReturnType(returnType)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setNonTradingDays"></a>}}
\if{latex}{\out{\hypertarget{method-setNonTradingDays}{}}}
\subsection{Method \code{setNonTradingDays()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$setNonTradingDays(nonTradingDays = "later")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setTestStatistics"></a>}}
\if{latex}{\out{\hypertarget{method-setTestStatistics}{}}}
\subsection{Method \code{setTestStatistics()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$setTestStatistics(testStatistics = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDataFiles"></a>}}
\if{latex}{\out{\hypertarget{method-setDataFiles}{}}}
\subsection{Method \code{setDataFiles()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$setDataFiles(
  dataFiles = c(request_file = "01_RequestFile.csv", firm_data = "02_firmData.csv",
    market_data = "03_MarketData.csv")
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AVCApplicationInput$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
