% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiPred.R
\name{epiPred}
\alias{epiPred}
\title{Epigenetic Modification Prediction}
\usage{
epiPred(FastaData,Species)
}
\arguments{
\item{FastaData}{Sequence file (.fasta format)}
\item{Species}{Model organism}
}
\value{
MethStatus: Sequences with their methylation state (methylated or non-methylated)
}
\description{
Predicting sequences with 6mA sites.
}
\examples{
\donttest{
library(EpiSemble)
data<-system.file("exdata/test.fasta", package = "EpiSemble")
pred<-epiPred(FastaData=data, Species="Rice")
}
}
\references{
Chen, W., Lv, H., Nie, F., & Lin, H. (2019). i6mA-Pred: identifying DNA N6-methyladenine 	sites in the rice genome. Bioinformatics, 35(16), 2796-2800.
}
