% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTS.R
\name{plotTS}
\alias{plotTS}
\title{Time series plot}
\usage{
plotTS(
  .data,
  xvar = "",
  xlabel = "",
  yvar = "",
  ylabel = "",
  fill_color = EcdcColors(col_scale = "qual", n = 1),
  log10_scale = FALSE,
  xvar_format = "\%Y",
  xvar_breaks = "1 year"
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the time variable (expects date format)
to plot on the x-axis in quotes}

\item{xlabel}{character string, label of the x axis}

\item{yvar}{character string, name of the numerical variable to plot on the y-axis in quotes}

\item{ylabel}{character string, label of the y axis}

\item{fill_color}{character string, hexadecimal colour to use in the graph;
(default to ECDC green \code{"#65B32E"},
see \code{EcdcColors(col_scale = "qual", n = 1)}}

\item{log10_scale}{boolean, \code{TRUE} if y-axis should be log scale
(default \code{FALSE} ,see \code{ggplot2::scale_y_log10})}

\item{xvar_format}{character string, time format to use to plot the x-axis
(\code{"\%Y"} for yearly labels or \code{"\%b \%Y"} for monthly labels)}

\item{xvar_breaks}{character string, time unit to use to plot the x-axis between breaks
(\code{"1 year"} or \code{"1 month"}, see \code{ggplot2::scale_x_date(date_breaks = ... )})}
}
\description{
This function draws a time series of the values of variable 'Yvar'
with the time variable 'Xvar' on the x-axis. \cr
Expects aggregated data.
}
\examples{
# --- Create dummy data
mydat <- data.frame(TimeCode = seq(as.Date("2008/1/1"), as.Date("2017/1/1"), "years"),
                    YValue = sample(1:500/10, 10))

# --- Plot the dummy data
plotTS(mydat,
       xvar = "TimeCode",
       xlabel = "Year",
       yvar = "YValue",
       ylabel = "Rate per 100 000 population",
       log10_scale = FALSE,
       xvar_format = "\%Y",
       xvar_breaks = "1 year")

}
\seealso{
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link[ggplot2]{ggplot}}
}
\keyword{timeseries}
