% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_cases}
\alias{report_cases}
\title{Report case counts by date of report}
\usage{
report_cases(
  case_estimates,
  case_forecast = NULL,
  delays,
  type = "sample",
  reporting_effect,
  CrIs = c(0.2, 0.5, 0.9)
)
}
\arguments{
\item{case_estimates}{A data.table of case estimates with the following variables: date, sample, cases}

\item{case_forecast}{A data.table of case forecasts with the following variables: date, sample, cases. If not supplied the
default is not to incorporate forecasts.}

\item{delays}{A list of delays (i.e incubation period/reporting delay) between infection and report.
Each list entry must also be a list containing the mean, standard deviation of the mean (mean_sd),
standard deviation (sd), standard deviation of the standard deviation and the maximum allowed value for the
that delay (assuming a lognormal distribution with all parameters excepting the max allowed value
on the log scale). To use no delays set this to \code{list()}.}

\item{type}{Character string indicating the method to use to transform counts. Supports either "sample"
which approximates sampling or "median" would shift by the median of the distribution.}

\item{reporting_effect}{A \code{data.table} giving the weekly reporting effect with the following variables:
\code{sample} (must be the same as in \code{nowcast}), \code{effect} (numeric scaling factor for each weekday), \code{day}
(numeric 1 - 7 (1 = Monday and 7 = Sunday)). If not supplied then no weekly reporting effect is assumed.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}
}
\value{
A list of \code{data.table}s. The first entry contains the following variables \code{sample}, \code{date} and \code{cases} with the second
being summarised across samples.
}
\description{
Report case counts by date of report
}
\examples{
\donttest{
# define example cases
cases <- EpiNow2::example_confirmed[1:40]

# set up example delays
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- EpiNow2::bootstrapped_dist_fit(rlnorm(100, log(6), 1), max_value = 30)
                        
# run model
out <- EpiNow2::estimate_infections(cases, samples = 100, 
                                    generation_time = generation_time,
                                    delays = list(incubation_period, reporting_delay),
                                    stan_args = list(warmup = 100, 
                                                     cores = ifelse(interactive(), 4, 1)),
                                    estimate_rt = FALSE)
                            
reported_cases <- report_cases(case_estimates = 
                                out$samples[variable == "infections"][, 
                                cases := as.integer(value)][, value := NULL],
                               delays = list(incubation_period, reporting_delay),
                               type = "sample")
print(reported_cases)
}
}
