% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.utils.R
\name{check_degdist_bal}
\alias{check_degdist_bal}
\title{Check Degree Distribution for Balance in Target Statistics}
\usage{
check_degdist_bal(num.g1, num.g2, deg.dist.g1, deg.dist.g2)
}
\arguments{
\item{num.g1}{Number of nodes in group 1.}

\item{num.g2}{Number of nodes in group 2.}

\item{deg.dist.g1}{Vector with fractional degree distribution for group 1.}

\item{deg.dist.g2}{Vector with fractional degree distribution for group 2.}
}
\description{
Checks for consistency in the implied network statistics
             of a two-group network in which the group size and group-specific
             degree distributions are specified.
}
\details{
This function outputs the number of nodes of degree 0 to g, where g is the
length of a fractional degree distribution vector, given that vector and the
size of the group. This utility is used to check for balance in implied degree
given that fractional distribution within two-group network simulations, in
which the degree-constrained counts must be equal across groups.
}
\examples{
# An unbalanced distribution
check_degdist_bal(num.g1 = 500, num.g2 = 500,
                  deg.dist.g2 = c(0.40, 0.55, 0.03, 0.02),
                  deg.dist.g1 = c(0.48, 0.41, 0.08, 0.03))

# A balanced distribution
check_degdist_bal(num.g1 = 500, num.g2 = 500,
                  deg.dist.g1 = c(0.40, 0.55, 0.04, 0.01),
                  deg.dist.g2 = c(0.48, 0.41, 0.08, 0.03))

}
\keyword{netUtils}
