% Generated by roxygen2 (4.0.1): do not edit by hand
\name{init.net}
\alias{init.net}
\title{Initial Conditions for Stochastic Network Models}
\usage{
init.net(i.num, r.num, i.num.m2, r.num.m2, status.vector, status.rand, ...)
}
\arguments{
\item{i.num}{number of initial infecteds. For bipartite models, this is the
number of initial mode 1 infected.}

\item{r.num}{number of initial recovereds. For bipartite models, this is the
number of initial mode 1 recovered. This parameter is only used for
the \code{SIR} model type.}

\item{i.num.m2}{number of initial infecteds in mode 2. This parameter is only
used for bipartite models.}

\item{r.num.m2}{number of initial recovereds in mode 2. This parameter is
only used for bipartite \code{SIR} models.}

\item{status.vector}{a vector of lenth equal to the size of the input network,
containing the status of each node. Setting status
here overrides any inputs passed in the \code{.num} arguments and also
overrides \code{status.rand=TRUE}.}

\item{status.rand}{if \code{TRUE} and not using \code{status.vector}, sets
infection based on random binomial draws from the distribution implied
by the number infected and recovered in each mode.}

\item{...}{additional initial conditions passed to model.}
}
\description{
Sets the initial conditions for stochastic network models
             simulated with \code{netsim}.
}
\details{
The initial conditions for a model solved with \code{\link{netsim}} should be
input into the \code{init.net} function. This function handles initial
conditions for both built-in models and new modules. For an overview of
specifying initial conditions across a variety of built-in network models,
consult the \href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel
Tutorial}.
}
\seealso{
Use \code{\link{param.net}} to specify model parameters and
         \code{\link{control.net}} to specify the control settings. Run the
         parameterized model with \code{\link{netsim}}.
}
\keyword{parameterization}

