% Generated by roxygen2 (4.0.1): do not edit by hand
\name{control.icm}
\alias{control.icm}
\title{Control Settings for Stochastic Individual Contact Models}
\usage{
control.icm(type, nsteps, nsims, rec.rand, b.rand, d.rand, initialize.FUN,
  infection.FUN, recovery.FUN, deaths.FUN, births.FUN, get_prev.FUN, verbose,
  verbose.int, ...)
}
\arguments{
\item{type}{disease type to be modeled, with the choice of \code{"SI"} for
Susceptible-Infected diseases, \code{"SIR"} for
Susceptible-Infected-Recovered diseases, and \code{"SIS"} for
Susceptible-Infected-Susceptible diseases.}

\item{nsteps}{number of time steps to solve the model over. This must be a
positive integer.}

\item{nsims}{number of simulations to run.}

\item{rec.rand}{if \code{TRUE}, use a stochastic recovery model, with the
number of recovered at each time step a function of random draws from
a binomial distribution with the probability equal to \code{rec.rate}.
If \code{FALSE}, then a deterministic rounded count of the expectation
implied by that rate.}

\item{b.rand}{if \code{TRUE}, use a stochastic birth model, with the
number of births at each time step a function of random draws from a
binomial distribution with the probability equal to the governing birth
rates. If \code{FALSE}, then a deterministic rounded count of the
expectation implied by those rates.}

\item{d.rand}{if \code{TRUE}, use a stochastic death model, with the number of
deaths at each time step a function of random draws from a binomial
distribution with the probability equal to the governing death rates.
If \code{FALSE}, then a deterministic rounded count of the expectation
implied by those rates.}

\item{initialize.FUN}{module to initialize the model at the outset, with the
default function of \code{\link{initialize.icm}}.}

\item{infection.FUN}{module to simulate disease infection, with the default
function of \code{\link{infection.icm}}.}

\item{recovery.FUN}{module to simulate disease recovery, with the default
function of \code{\link{recovery.icm}}.}

\item{deaths.FUN}{module to simulate deaths or exits, with the default
function of \code{\link{deaths.icm}}.}

\item{births.FUN}{module to simulate births or entries, with the default
function of \code{\link{births.icm}}.}

\item{get_prev.FUN}{module to calculate disease prevalence at each time step,
with the default function of \code{\link{get_prev.icm}}.}

\item{verbose}{if \code{TRUE}, print model progress to the console.}

\item{verbose.int}{time step interval for printing progress to console, where
0 (the default) prints completion status of entire simulation and
positive integer \code{x} prints progress after each \code{x} time
steps.}

\item{...}{additional control settings passed to model.}
}
\description{
Sets the controls for stochastic individual contact models
             simulated with \code{\link{icm}}.
}
\details{
\code{control.icm} sets the required control settings for any stochastic
individual contact model solved with the \code{\link{icm}} function. Controls
are required for both built-in model types and when passing original process
modules. For an overview of control settings for built-in ICM class models,
consult the \href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel
Tutorial}. For all built-in models, the \code{type} argument is a necessary
parameter and it has no default.
}
\section{New Modules}{

Built-in ICM models use a set of module functions that specify
how the individual agents in the population are subjected to infection, recovery,
demographics, and other processes. Core modules are those listed in the
\code{.FUN} arguments. For each module, there is a default function used in
the simulation. The default infection module, for example, is contained in
the \code{\link{infection.icm}} function.

For original models, one may substitute replacement module functions for any
the default functions. New modules may be added to the workflow at each time
step by passing a module function via the \code{...} argument. Further details
and examples of passing new modules to \code{icm} are found in the
\href{http://statnet.org/EpiModel/vignette/NewICMs.html}{Solving New ICMs with
EpiModel} tutorial.
}
\seealso{
Use \code{\link{param.icm}} to specify model parameters and
         \code{\link{init.icm}} to specify the initial conditions. Run the
         parameterized model with \code{\link{icm}}.
}
\keyword{parameterization}

