% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfcheck.R
\name{perfcheck}
\alias{perfcheck}
\title{Check the statistical performance of EpiLPS with simulations}
\usage{
perfcheck(S = 10, serial_interval, scenario = 3, K = 30, method = "LPSMAP",
          slidewindow = 6, ci_level = 0.95,
          themetype = c("classic","gray","light","dark"), seed = 123)
}
\arguments{
\item{S}{The total number of replications.}

\item{serial_interval}{The serial interval distribution.}

\item{scenario}{The scenario (1,2,3 or 4).}

\item{K}{Number of (cubic) B-splines in the basis.}

\item{method}{Either LPSMAP (fully sampling-free) or LPSMALA (MCMC-based).}

\item{slidewindow}{The sliding window for EpiEstim (defaults to 1 week).}

\item{ci_level}{Level of the credible intervals to be computed.}

\item{themetype}{What theme should be use for plotting the R curves?}

\item{seed}{A seed for reproducibility.}
}
\value{
An object of class \code{perfcheck} containing a table of summary
 statistics for the EpiLPS and EpiEstim routines.
}
\description{
The \code{perfcheck()} routine can be used to check the performance of EpiLPS
in various epidemic scenarios. The user can choose between 4 scenarios,
each scenario corresponding to a different data generating process for the
incidence data with a specific target dynamics for the reproduction number.
The aim of these simulations is to assess how close EpiLPS can reproduce
the target reproduction number curve. Different metrics are given as outputs
and comparisons with the \code{estimate_R()} routine of the
EpiEstim package (Cori et al. 2013) is also shown.
}
\examples{
simex <- perfcheck(S = 10, serial_interval = c(0.2, 0.4, 0.2, 0.1, 0.1),
                   scenario = 3, ci_level = 0.95,  seed = 1234, themetype = "gray")

}
\references{
Cori, A., Ferguson, N.M., Fraser, C., Cauchemez, S. (2013).
 A new framework and software to estimate time-varying reproduction numbers
 during epidemics. \emph{American Journal of Epidemiology},
 \strong{178}(9):1505-1512.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
