% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{grahamReplication}
\alias{grahamReplication}
\title{Relative risks from an adjusted new-user cohort design}
\format{A data frame with 126 rows and 4 variables: \describe{ \item{outcomeName}{Name of the outcome}
\item{trueLogRr}{The log of the true effect size. Only provided for negative and positive controls, 
is NA for the outcome of interest (GI bleeding).} \item{logRr}{The log of the incidence rate ratio} \item{seLogRr}{
The standard error of the log of the incidence rate ratio} }}
\usage{
data(grahamReplication)
}
\description{
Relative risks from an adjusted new-user cohort design
}
\details{
A dataset containing the incidence rate ratios (and standard errors) produced using a new-user 
cohort design that compares new-users of dabigatran to new-users of warfarin for the outcome of 
GI hemorrhage. The dataset includes estimates both for the outcome ofinterest as well as negative 
and positive control outcomes. Subject are required to have 183 days of continuous observation 
prior to initiating treatment, be at least 65 years old at index date, and are required to have 
no prior exposure to warfarin or dabigatran (or any other novel anticoagulant). Furthermore, 
subjects are required to use the treatment for the indication of atrial fibrillation or atrial 
flutter, which is enforced by requiring a prior diagnosis of atrial fibrillation or flutter, 
and no prior diagnosis of other indications. Propensity scores are generated by fitting a model 
for predicting treatment assignment based on baseline patient characteristics, and are used to 
perform one-on-one matching. Hazard ratios are estimated through a Cox regression on the matched 
population. Time-at-risk is defined as starting on the day after initiating treatment and stopping 
when treatment is stopped, when the outcome occurs, or observation time ends, whichever comes first. 
The original study (Graham et al 2016) uses the Medicare database. For our replication, we use the 
Truven Medicare Supplementary Beneficiaries database. We analyze 15,796 dabigatran-exposed and 15,796 
warfarin-exposed subjects. For more information on this set see Schuemie et al (2017).
}
\references{
Schuemie MJ, Hripcsak G, Ryan PB, Madigan D, Suchard MA. Empirical confidence interval calibration 
for population-level effect estimation studies in observational healthcare data. Proc Natl Acad Sci 
U S A. 2018 Mar 13;115(11):2571-2577
 
Graham DJ, Reichman ME, Wernecke M, Hsueh YH, Izem R, Southworth MR, Wei Y, Liao J, Goulding MR, Mott K, 
Chillarige Y, MaCurdy TE, Worrall C, Kelman JA.  Stroke, Bleeding, and Mortality Risks in Elderly Medicare 
Beneficiaries Treated With Dabigatran or Rivaroxaban for Nonvalvular Atrial Fibrillation. JAMA Intern 
Med 176(11):1662-1671, 2016
}
\keyword{datasets}
