% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__GA.R
\name{config_ga}
\alias{config_ga}
\title{Configuration object for the Genetic Algorithm}
\usage{
config_ga(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  keep_fraction = 0.4,
  mutation_rate = 0.1
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of chromosomes.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{keep_fraction}{fraction of the population that survives for the next step of
mating. Default is \code{0.4}.}

\item{mutation_rate}{probability of mutation. Default is \code{0.1}.}
}
\value{
\code{config_ga} returns an object of class \code{GAConfig}.
}
\description{
Create a configuration object for the Genetic Algorithm (GA). At minimum the number of iterations
(parameter \code{iterations}) and the number of chromosomes (parameter \code{population_size}) have
to be provided.
}
\references{
\insertRef{holland}{EmiR}
}
