% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcular.elasticidades.R
\name{calcular.elasticidades}
\alias{calcular.elasticidades}
\title{Calculo elasticidades de todos os grupos de receitas}
\usage{
calcular.elasticidades(Receitas, Hpib, Hpet = NULL, tce, fim)
}
\arguments{
\item{Receitas}{Matrix/ts contendo vários grupos de receitas que devem
ser identificadas por um dos seguintes nomes: TRT, TFP, TRC, TI, TM,
TGC, TRAN, ICMS, ISS, ROY e PE.}

\item{Hpib}{Série de tempo do hiato do PIB.}

\item{Hpet}{Série de tempo do hiato do Petróleo (necessário se ROY e PE
estiverem presentes).}

\item{tce}{Série de tempo de taxa de cambio efetiva, utilizada como
variável de controle.}

\item{fim}{Período final para o cálculo das elasticidades.}
}
\value{
Extensa lista com todas as combinações possíveis de nível, inclinacao e
sazon, para os 11 grupos de receita utilizados.
}
\description{
Função para estimar as elasticidades de todos os grupos de receitas. Exige
entrada de dados no formato correto.
}
\examples{
\dontrun{data(Exemplo)}
\donttest{resultado <- calcularElasticidades(Exemplo$receitas, 
                         Exemplo$Hpib, Exemplo$Hpet, c(2015,4))}

receitas <- ts(matrix(runif(836), nrow=76, ncol=11), start=1997,
                  end=c(2015,4), frequency=4)
Hpib <- ts(runif(76), start=1997, end=c(2015,4), frequency=4)
Hpet <- ts(runif(76), start=1997, end=c(2015,4), frequency=4)
\donttest{resultado <- calcularElasticidades(receitas, Hpib, Hpet, fim=c(2015,4))} 
}
\seealso{
\code{\link{todas.dlms}}
\code{\link{criar.dlm}}
\code{\link{Exemplo}}
\code{\link{exportar}}
}

