% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{size_source_pool}
\alias{size_source_pool}
\title{SizeSourcePoolDraw Size Overlap Randomization Algorithm}
\usage{
size_source_pool(speciesData = 21:30, sourcePool = runif(n = 2 *
  length(speciesData), min = 10, max = 50), speciesProbs = rep(1,
  length(sourcePool)))
}
\arguments{
\item{speciesData}{a vector of observed body sizes.}

\item{sourcePool}{a vector of body sizes of species in the user-defined
pool of potential colonists.}

\item{speciesProbs}{a vector of relative colonization weights of
length 'sourcePool'.}
}
\value{
Returns a vector of body sizes of an assemblage randomly drawn
from a user-defined source pool.
}
\description{
Function to randomize body sizes by drawing species from a
user-defined source pool. Species are drawn without replacement,
and there is a specified probability vector for the source pool species
}
\note{
Although delineating a source pool of species and estimating their
relative colonization probabilities is difficult, this is the most realistic
approach to constructing a null distribution.
}
\examples{
obsOverlap <- size_source_pool(dataRodents$Sonoran)
}
\references{
Strong, D.R. Jr., L.A. Szyska, and D. Simberloff. 1979. Tests of
community-wide character displacement against null hypotheses. Evolution 33:
897-913.
Schluter, D. and P.R. Grant. 1984. Determinants of morphological patterns in
communities of Darwin's finches. American Naturalist 123: 175-196.
}

