% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecogen.6OF6.converters.R
\name{ecogen2geneland}
\alias{ecogen2geneland}
\title{Creating input data for Geneland with an ecogen object}
\usage{
ecogen2geneland(
  eco,
  dir = "",
  ncod = NULL,
  ploidy = 2,
  to_numeric = FALSE,
  nout = 3,
  recode = c("all", "column", "paired"),
  replace_in = NULL,
  replace_out = NULL,
  ...
)
}
\arguments{
\item{eco}{Object of class "ecogen"}

\item{dir}{output path. Default = "" (current directory).}

\item{ncod}{Number of digits coding each allele
(e.g., 1: x, 2: xx, 3: xxx, etc.).}

\item{ploidy}{Ploidy of the data.}

\item{to_numeric}{Recode the genetic data into numeric format? If TRUE, 
the functions performs the correction via \code{\link{eco.format}}.
Additional formatting parameters can be passed to this function.}

\item{nout}{Number of digits in the output when to_numeric = TRUE.}

\item{recode}{Recode mode when to_numeric = TRUE: "all" for recoding
the data considering all the individuals values at once (e.g., protein data), 
"column" for recoding the values by column (e.g., microsatellite data), "paired" 
for passing the values of allelic states and corresponding replacement values, using 
the replace_in and replace_out arguments (e.g. replace_in = c("A", "T", "C", "G"),
replace_out = c(1,2,3,4)).}

\item{replace_in}{vector with states of the data matrix to be replaced, when recode = "paired".
This argument must be used in conjunction with the argument "replace_out".}

\item{replace_out}{vector with states of the data matrix used for replacement, when recode = "paired".
This argument must be used in conjunction with the argument "replace_in".}

\item{...}{Additional parameters passed to \code{\link{eco.format} when to_numeric = TRUE}}
}
\value{
XY.txt Matrix with coordinates.

NAMES.txt Matrix with row names.

P.txt Matrix with phenotypic data.

G.txt Matrix with genotypic data.
}
\description{
This function creates four data frames (XY.txt, NAMES.txt, P.txt, G.txt) 
in the indicated directory (default: working directory), which can be loadedin Geneland.
}
\examples{

\dontrun{

data(eco.test)
ecogen2geneland(eco, dir = "", ncod=1)

}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
