% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.rankplot.R
\docType{methods}
\name{eco.rankplot}
\alias{eco.rankplot}
\alias{eco.rankplot,eco.gm,dataframeORmatrix,missing-method}
\alias{eco.rankplot,eco.gm-method}
\alias{eco.rankplot,eco.multiboot,dataframeORmatrix,character-method}
\alias{eco.rankplot,eco.multiboot-method}
\title{Plot for Getis- Ord's G or local-Moran's I analysis}
\usage{
eco.rankplot(input, XY, var = NULL)

\S4method{eco.rankplot}{eco.multiboot,dataframeORmatrix,character}(input, XY,
  var = NULL)

\S4method{eco.rankplot}{eco.gm,dataframeORmatrix,missing}(input, XY,
  var = NULL)
}
\arguments{
\item{input}{Getis-Ord's G or local-Moran's I analysis result of
\code{\link{eco.autocor}}, \code{\link{eco.localmoran}} or
\code{\link{eco.getisord}}.}

\item{XY}{data frame or matrix with X-Y coordinates.}

\item{var}{Variable to plot when an  \code{\link{eco.autocor}}
result should be plotted.}
}
\description{
This function generates a plot for the
detection of zones with similar values of autocorrelation
at different lag distance intervals for \code{\link{eco.autocor}} results,
or a plot for a given connection network (as listw)
for \code{\link{eco.localmoran}} or \code{\link{eco.getisord}} results.
The X and Y axes corresponds  to the rank of the X and Y coordinates,
respectively.
}
\examples{
\dontrun{
data(eco.test)
eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "getisord", nsim = 10, indvar="P6")
eco.rankplot(eco.ac, eco$XY, "P6")

require(adegenet)
con<-chooseCN(eco$XY, type = 1, result.type = "listw",
plot.nb = FALSE)
getis <- eco.getisord(eco$P[, 3], con, nsim = 99, classG = "G")
eco.rankplot(getis, eco$XY)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

