% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.moran.R
\name{eco.moran}
\alias{eco.moran}
\title{Moran's I statistic with Monte-Carlo test}
\usage{
eco.moran(z, con, nsim = 99, alternative = c("auto", "two.sided", "greater",
  "less"), test = c("permutation", "bootstrap"), adjust.n = TRUE,
  plotit = TRUE)
}
\arguments{
\item{z}{vector for the analysis.}

\item{con}{An object of class listw or a weight square matrix, giving
the weights for the analysis.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the hypothesis by difference between the median of the simulations
and the observed value. Other options are: "two.sided", "greater" and "less".}

\item{test}{If "bootstrap", the program generates a bootstrap resampling and the
associated confidence intervals of the null hypothesis. If "permutation" (default)
a permutation test is made and the p value is calculated.}

\item{adjust.n}{If TRUE (default) the program adjust the number of
individuals (n) to those with non null conections.}

\item{plotit}{Should be printed a histogram of the simulation?}
}
\description{
This program computes the Moran's I statistic for the data z,
with p values or a confidence interval for the null hypothesis.
}
\examples{
\dontrun{
data(eco.test)
require(adegenet)
con<-chooseCN(eco$XY, type = 1, result.type = "listw", plot.nb = FALSE)
eco.moran(eco$P[, 3], con, nsim = 200)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

