% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvi.R
\name{mvi}
\alias{mvi}
\title{Multivariate Variance Index function}
\source{
Brock, W.A. & Carpenter, S.R. (2006) Variance as a leading indicator of regime shift in ecosystem services. Ecology and Society 11(2): 9.
}
\usage{
mvi(data, winsize = 50)
}
\arguments{
\item{data}{A numeric matrix of species abundances, names across columns, time across rows. The first column is a time vector, the remainder are species values.}

\item{winsize}{Numeric. Defines the window size of the rolling window as a percentage of the time series length.}
}
\value{
A matrix where the first column is last time index of the window and the second column is the estimated index value.
}
\description{
Calculate a multivariate variance following Brock, W. A., and S. R. Carpenter. 2006. Variance as a leading indicator of regime shift in ecosystem services. Ecology and Society 11(2): 9.
}
\examples{
#Load the multivariate simulated
#dataset `simTransComms`

data(simTransComms)

#Estimate the MVI for the second community

egMVI <- mvi(data = simTransComms$community2[,2:7],
winsize = 10)

}
