% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.enm.R
\name{visualize.enm}
\alias{visualize.enm}
\title{visualize.enm, Makes a heatmap of suitability of habitat in environment space according to a given model}
\usage{
visualize.enm(
  model,
  env,
  nbins = 100,
  layers = names(env)[1:2],
  plot.test.data = FALSE,
  plot.points = TRUE,
  minmax = NA
)
}
\arguments{
\item{model}{An enmtools.model object}

\item{env}{A set of environmental layers}

\item{nbins}{The number of bins per layer to use for drawing environment space}

\item{layers}{A vector of layer names to use for drawing environment space}

\item{plot.test.data}{Logical determining whether test data should be plotted, if present.  If test data is plotted, it will appear as translucent green triangles.}

\item{plot.points}{Logical determining whether presence points should be plotted on suitability plot}

\item{minmax}{A named list of minima and maxima for each axis, in case the user wants to constrain or expand the space over which models are plotted.}
}
\value{
suit.plot A list containing two dimensional plot of an ENM in environment space and a plot of the available environments.
}
\description{
visualize.enm, Makes a heatmap of suitability of habitat in environment space according to a given model
}
\examples{
data(iberolacerta.clade)
data(euro.worldclim)
aurelioi.glm <- enmtools.glm(iberolacerta.clade$species$aurelioi, euro.worldclim,
f = pres ~ poly(bio1, 4) + poly(bio12, 4))
visualize.enm(aurelioi.glm, euro.worldclim, layers = c("bio1", "bio12"))
}
\keyword{enm}
\keyword{niche}
\keyword{plot}
\keyword{sdm}
