% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSC_results.R
\name{plot.EMSC}
\alias{plot.EMSC}
\alias{print.EMSC}
\alias{summary.EMSC}
\title{Plot, print and summary methods for EMSC}
\usage{
\method{plot}{EMSC}(
  x,
  y,
  spec = "all",
  what = c("raw", "reference", "polynomials", "interferents", "constituents",
    "replicates", "corrected"),
  where = c(1, 1, 2, 3, 3, 4, 5),
  revX = FALSE,
  labels,
  type,
  lty,
  lwd = NULL,
  pch,
  cex = NULL,
  col,
  xlab,
  ylab,
  pretty.xlabels = TRUE,
  xlim,
  ...
)

\method{print}{EMSC}(x, ...)

\method{summary}{EMSC}(object, ...)
}
\arguments{
\item{x}{An object fitted by the \code{EMSC} function.}

\item{y}{Unused parameter to conform to generic \code{plot}.}

\item{spec}{Parameter specifying if all spectra should be plotted (default)
or a subset (\code{numeric} vector).}

\item{what}{\code{character} vector defining what to plot.}

\item{where}{\code{integer} vector defining which elements should be plotted
in which subplot.}

\item{revX}{Reverse x axis (default = FALSE).}

\item{labels}{"names" or "numbers" uses column names for x axis labelling.}

\item{type}{plotting type (line, points, ...).}

\item{lty}{line type.}

\item{lwd}{line width.}

\item{pch}{plot character.}

\item{cex}{symbol/line scaling.}

\item{col}{symbol/line colour.}

\item{xlab}{x label.}

\item{ylab}{y label.}

\item{pretty.xlabels}{Use pretty x labels (default = TRUE).}

\item{xlim}{x limits.}

\item{...}{Additional arguments to \code{matplot}.}

\item{object}{An object fitted by the \code{EMSC} function.}
}
\value{
No return.
}
\description{
Plotting routine for \code{EMSC} ojects. The default behaviour is to
plot raw spectra, reference spectrum, polynomials, interferents,
constituents, replicate model and corrected spectra. This can be
tweaked by changing the parameters.
}
\details{
The parameters \code{what} and \code{where} must match
so that the parts of the EMSC model end up in the correct subplot.
There are limits to the freedom of this function.

\code{print} and \code{summary} return minimal information on the
EMSC object.
}
\examples{
data(fishoil, package = "EMSC")
Raman      <- fishoil$Raman[, 850:3300]
EMSC.rep   <- EMSC(Raman, degree = 6, reference = Raman[30, ],
                   replicates = fishoil$replicates)
plot(EMSC.rep)
                   
}
\seealso{
\code{\link{EMSC}} \code{\link{EMSC_model}} \code{\link{plot.EMSC}}
}
\author{
Kristian Hovde Liland
}
