% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.l.opt.R
\name{get.l.opt}
\alias{get.l.opt}
\title{Identify optimum weight transformation value}
\usage{
get.l.opt(X, l, quality = "mRt", Vqn, rotation, plot = TRUE, ...)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{l}{\code{Numeric} vector, weight transformation values to test.}

\item{quality}{\code{Character} scalar, quality measure for against 
which to test the influence of \code{l}. See details for a list 
of the a vailable keywords. Default is \code{"mRt"}.}

\item{Vqn}{\code{Numeric} matrix specifying optional unscaled user-defined
end-member loadings.}

\item{rotation}{\code{Character} scalar, rotation type, default is "Varimax"
(cf. \code{\link{EMMA}} for further information).}

\item{plot}{\code{Logical} scalar, optional graphical output of the result.}

\item{\dots}{Further arguments passed to the function.}
}
\value{
\code{Numeric} scalar, weight tranformation value with optimal 
EMMA result.
}
\description{
This function returns for a series of input vaules the weight 
transformation value, which yielded the highest measure of model quality.
}
\details{
The parameter \code{quality} can be one out of the following keywords: 
\code{"mRm"}, \code{"mRn"}, \code{"mRt"}, \code{"mEm"}, \code{"mEn"} and 
\code{"mEt"}. See \code{\link{EMMA}} for definition of these keywords.
}
\examples{

## load example data set
data(example_X)
data(example_EMpot)

## get optimal l-value, uncomment to run
# get.l.opt(X = X, 
#           l = seq(from = 0, to = 0.1, by = 0.01), 
#           Vqn = EMpot$Vqn, 
#           quality = "mRt")

}
\seealso{
\code{\link{EMMA}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
