% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMMA.R
\name{EMMA}
\alias{EMMA}
\title{End-member modelling analysis algorithm.}
\usage{
EMMA(
  X,
  q,
  l,
  c,
  Vqn,
  classunits,
  ID,
  EM.ID,
  rotation = "Varimax",
  plot = FALSE,
  ...
)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{q}{\code{Numeric} scalar, number of end-members to be modelled.}

\item{l}{\code{Numeric} scalar or vector, weight transformation
limit, i.e.  quantile. Set to zero if omitted.}

\item{c}{\code{Numeric} scalar, constant sum scaling parameter, e.g.
1, 100, 1000. Set to 100 if omitted.}

\item{Vqn}{\code{Numeric} matrix, optional unscaled user-defined
end-member loadings. If provided, these are used instead of model-derived
ones. See details.}

\item{classunits}{\code{Numeric} vector, optional class units 
(e.g. micrometers or phi-units) of the same length as columns of \code{X}.}

\item{ID}{\code{Numeric} or character vector, optional sample IDs of the 
same length as rows of X.}

\item{EM.ID}{\code{Character} vector, end-member names. If present, 
these will be set as row-names of the output data set and used in the 
legend text.}

\item{rotation}{\code{Character} scalar, rotation type, default is 
"Varimax". See details.}

\item{plot}{\code{Logical} scalar, optional graphical output of the results,
default is FALSE. If set to TRUE, end-member loadings and end-member scores
are plotted.}

\item{\dots}{Additional arguments passed to the plot function. Since the
function returns two plots some additional graphical parameters must be
specified as vector with the first element for the first plot and the second
element for the second plot.}
}
\value{
A list with numeric matrix objects. \item{loadings}{Normalised
rescaled end-member loadings.} \item{scores}{Rescaled end-member scores.}
\item{Vqn}{Normalised end-member loadings.} \item{Vqsn}{Normalised rescaled
end-member loadings.} \item{Mqs}{Rescaled end-member scores.}
\item{Xm}{Modelled data.} \item{modes}{Mode class of end-member loadings.}
\item{Mqs.var}{Explained variance of end-members} \item{Em}{Absolute
row-wise model error.} \item{En}{Absolute column-wise model error.} 
\item{RMSEm}{row-wise root mean square erroe} \item{RMSEn}{column-wise root 
mean square erroe} \item{Rm}{Row-wise (sample-wise) explained variance.} 
\item{Rn}{Column-wise (variable-wise) explained variance.} \item{ol}{Number 
of overlapping end-members.}
}
\description{
A multivariate data set (m samples composed of n variables) is decomposed by
eigenspace analysis and modelled with a given number of end-members (q).
Several steps of scaling, transformation, normalisation, eigenspace
decomposition, factor rotation, data modelling and evaluation are performed.
}
\details{
The parameter \code{Vqn} is useful when \code{EMMA} shall be performed with 
a set of prior unscaled end-members, e.g. from other data sets that are to 
be used as reference or when modelling a data set with mean end-members, as
in the output of \code{robust.loadings}.\cr
The rotation type \code{Varimax} was used by Dietze et al. (2012). In this 
R package, one out of the rotations provided by the package GPArotation 
is possible, as well. However, tests showed that the rotation type has no 
dramatic consequences for the result.\cr 
The function values \code{$loadings} and \code{$scores} are redundant. They 
are essentially the same as \code{$Vqsn} and \code{$Mqs}. However, they are 
included for user convenience.
}
\examples{

## load example data and set phi-vector
data(example_X)
phi <- seq(from = 1, to = 10, length.out = ncol(X))

## perform EMMA with 5 end-members
EM <- EMMA(X = X, q = 5, l = 0.05, c = 100, plot = TRUE)

## perform EMMA with 4 end-members and more graphical settings
EM <- EMMA(X = X, q = 4, l = 0.05, c = 100, 
           plot = TRUE,
           EM.ID = c("EM 1", "EM 2", "EM 3", "EM 4"),
           classunits = phi,
           xlab = c(expression(paste("Class [", phi, "]")), "Sample ID"),
           cex = 0.7,
           col = rainbow(n = 4))

}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.\cr
Klovan JE, Imbrie J. 1971. An Algorithm and FORTRAN-IV Program for
Large-Scale Q-Mode Factor Analysis and Calculation of Factor Scores.
Mathematical Geology 3: 61-77. Miesch AT. 1976. Q-Mode factor analysis of
geochemical and petrologic data matrices with constant row sums. U.S.
Geological Survey Professsional Papers 574.
}
\seealso{
\code{\link{test.parameters}}, \code{\link{rotations}},
\code{\link{eigen}}, \code{\link{nnls}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
