% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modPK.R
\name{run_Build_PK_IV}
\alias{run_Build_PK_IV}
\title{Build-PK-IV Module}
\usage{
run_Build_PK_IV(
  conc,
  dose,
  lab.dat = NULL,
  lab.vars = NULL,
  demo.list = NULL,
  demo.vars = NULL,
  demo.abbr = NULL,
  pk.vars,
  drugname,
  check.path,
  missdemo_fn = "-missing-demo",
  faildupbol_fn = "DuplicateBolus-",
  date.format = "\%m/\%d/\%y \%H:\%M:\%S",
  date.tz = "America/Chicago"
)
}
\arguments{
\item{conc}{concentration data, the output of \code{\link{run_DrugLevel}} 
or a correctly formatted data.frame}

\item{dose}{dose data, the output of \code{\link{run_MedStrI}} or a
correctly formatted data.frame}

\item{lab.dat}{lab data, if available. the output from \code{\link{run_Labs}} or 
a correctly formatted list}

\item{lab.vars}{variables to include from lab data}

\item{demo.list}{demographic information, if available. the output from 
\code{\link{run_Demo}} or a correctly formatted data.frame}

\item{demo.vars}{variables to include from demographic data}

\item{demo.abbr}{character vector used to rename/abbreviate demo variables}

\item{pk.vars}{variables to include from PK data. the variables 
c('mod_id_visit', 'time', 'conc', 'dose', 'rate', 'event') are required}

\item{drugname}{drug of interest, included in filename of check files}

\item{check.path}{path to \sQuote{check} directory, where check files are
created}

\item{missdemo_fn}{filename for checking NA frequency among demographic data}

\item{faildupbol_fn}{filename for duplicate bolus data}

\item{date.format}{output format for \sQuote{date} variable}

\item{date.tz}{output time zone for \sQuote{date} variable}
}
\value{
PK data set
}
\description{
This module builds PK data for intravenously (IV) administered medications.
}
\details{
See EHR Vignette for Structured Data.
}
\examples{
\dontrun{

# make fake data
set.seed(6543)

build_date <- function(x) as.character(seq(x, length.out=5, by="1 hour"))
dates <- unlist(lapply(rep(Sys.time(),3), build_date))

plconc <- data.frame(mod_id = rep(1:3,each=5),
                   mod_id_visit = rep(1:3,each=5)+0.1,
                   event = rep(1:5,times=3),
                   conc.level = 15*exp(-1*rep(1:5,times=3))+rnorm(15,0,0.1),
                   date.time = as.POSIXct(dates))

ivdose <- data.frame(mod_id = 1:3,
                     date.dose = substr(dates[seq(1,15,by=5)],1,10),
                     infuse.time.real = NA, infuse.time = NA, infuse.dose = NA,
                     bolus.time = as.POSIXct(dates[seq(1,15,by=5)])-300,
                     bolus.dose = 90,
                     maxint = 0L,
                     weight = 45)


run_Build_PK_IV(conc = plconc, dose = ivdose,
                pk.vars = c('mod_id_visit', 'time', 'conc', 'dose', 'rate', 'event'))
}

}
