% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readDataFromFile}
\alias{readDataFromFile}
\title{Basic Data Import for Water Flow Data}
\usage{
readDataFromFile(filePath, fileName, hasHeader = TRUE, separator = ",")
}
\arguments{
\item{filePath}{character specifying the path to the file}

\item{fileName}{character name of file to open}

\item{hasHeader}{logical true if the first row of data is the column headers}

\item{separator}{character character that separates data cells}
}
\value{
retval dataframe with dateTime, value, and code columns
}
\description{
Imports data from user-supplied data file. Specifically used to import water flow data for use in the EGRET package.
For EGRET usage, the first column is expected to be dates. If the data is daily data, then next column is
expected to be the measured values. If the data is sampled data, the next column is remark codes, and the third
column is values.
}
\examples{
filePath <- system.file("extdata", package="EGRET")
fileName <- 'ChoptankRiverFlow.txt'
ChopData <- readDataFromFile(filePath,fileName, separator="\\t")
}
\keyword{data}
\keyword{file}
\keyword{import}

