% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readUserSample}
\alias{readUserSample}
\title{Import user sample data for EGRET analysis}
\usage{
readUserSample(filePath, fileName, hasHeader = TRUE, separator = ",",
  interactive = TRUE)
}
\arguments{
\item{filePath}{character specifying the path to the file}

\item{fileName}{character name of file to open}

\item{hasHeader}{logical true if the first row of data is the column headers}

\item{separator}{character character that separates data cells}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
Sample dataframe
}
\description{
Imports data from a user-supplied file, and converts it to a Sample data frame
(including summing multiple constituents), appropriate for EGRET analysis.
First column is date, second is remark code, and third is value. If multiple constituents
are to be combinded with interval censoring, additional columns can be inserted, each starting with
remark code (specifically looking for <), and values.
}
\examples{
filePath <- system.file("extdata", package="EGRET")
fileName <- 'ChoptankRiverNitrate.csv'
Sample <- readUserSample(filePath,fileName, separator=";",interactive=FALSE)
}
\seealso{
\code{\link{compressData}}, \code{\link{populateSampleColumns}}
}
\keyword{data}
\keyword{file}
\keyword{import}

