% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readUserInfo}
\alias{readUserInfo}
\title{Import Metadata from User-Generated File}
\usage{
readUserInfo(filePath, fileName, hasHeader = TRUE, separator = ",",
  interactive = TRUE)
}
\arguments{
\item{filePath}{character specifying the path to the file}

\item{fileName}{character name of file to open}

\item{hasHeader}{logical true if the first row of data is the column headers}

\item{separator}{character character that separates data cells}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
INFO dataframe with agency, site, dateTime, value, and code columns
}
\description{
Populates INFO data frame for EGRET study. Accepts a user generated file with any metadata that might
be important for the analysis.
Additionally, EGRET analysis requires:"drainSqKm", "staAbbrev", "constitAbbrev",
"param.units", "paramShortName","shortName". If interactive=TRUE, the function will ask for these
fields if they aren't supplied in the file.
}
\examples{
filePath <- system.file("extdata", package="EGRET")
filePath <- paste(filePath,"/",sep="")
fileName <- 'infoTest.csv'
INFO <- readUserInfo(filePath,fileName, separator=",",interactive=FALSE)
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

