% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGA.fit.R
\name{EGA.fit}
\alias{EGA.fit}
\title{EGA Optimal Model Fit using Entropy}
\usage{
EGA.fit(data, model = c("glasso", "TMFG"), steps = c(3, 4, 5, 6, 7, 8))
}
\arguments{
\item{data}{A dataset}

\item{model}{A string indicating the method to use.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
This is the default method}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{steps}{Range of steps to be used in the model selection.
Defaults from 3 to 8 steps (based on Pons & Latapy, 2006)}
}
\value{
Returns a list containing:

\item{EGA}{The \code{\link{EGA}} output for the best fitting model}

\item{steps}{The number of steps used in the best fitting model from
the \code{\link[igraph]{cluster_walktrap}} algorithm}

\item{EntropyFit}{The Entropy Fit Index for the unique solutions given the range of steps
(vector names represent the number of steps)}

\item{Lowest.EntropyFit}{The lowest value for the Entropy Fit Index}
}
\description{
Estimates the best fitting model using \code{\link{EGA}}.
The number of steps in the \code{\link[igraph]{cluster_walktrap}} detection
algorithm is varied and unique community solutions are compared using
\code{\link{entropyFit}}.
}
\examples{
\donttest{
#estimate normal EGAtmfg
tmfg <- EGA(data = wmt2[,7:24], model = "TMFG")

#estimate optimal EGAtmfg
tmfg.opt <- EGA.fit(data = wmt2[,7:24], model = "TMFG")

#estimate Entropy Fit Index
entropyFit(data = wmt2[,7:24], structure = tmfg.opt$EGA$wc)$Entropy.Fit
entropyFit(data = wmt2[,7:24], structure = tmfg$wc)$Entropy.Fit
}

}
\references{
Pons, P., & Latapy, M. (2006).
Computing communities in large networks using random walks.
\emph{Journal of Graph Algorithms and Applications}, \emph{10}, 191-218.
doi:\href{https://doi.org/10.7155/jgaa.00185}{10.7155/jgaa.00185}
}
\seealso{
\code{\link{bootEGA}} to investigate the stability of EGA's estimation via bootstrap,
\code{\link{EGA}} to estimate the number of dimensions of an instrument using EGA,
and \code{\link{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
