% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_EEAaq_df.R
\name{is_EEAaq_df}
\alias{is_EEAaq_df}
\title{Check if a given object is an \code{EEAaq_df} class object}
\usage{
is_EEAaq_df(data)
}
\arguments{
\item{data}{the object for which verify the if it belongs to the \code{EEAaq_df} class.}
}
\value{
logical value (T ot F). If \code{TRUE} the object given in input is an \code{EEAaq_df} object.
If \code{FALSE} the object doesn't belong to the \code{EEAaq_df} class.
}
\description{
Given an object as input, \code{is_EEAaq_df} verify that the given object belongs
to the \code{EEAaq_df} class.
}
\examples{
\donttest{
#Download a dataset with the function EEAaq_get_data, which generate an EEAaq_df object.
data <- EEAaq_get_data(zone_name = "15146", NUTS_level = "LAU",LAU_ISO = "IT",
pollutants = "PM10", from = "2023-01-01", to = "2024-08-29",  verbose = TRUE)

#Check if the imported object belongs to the EEAaq_df class
is_EEAaq_df(data = data)}

}
