% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_entity_size.R
\name{read_data_entity_size}
\alias{read_data_entity_size}
\title{Read data entity size}
\usage{
read_data_entity_size(packageId, entityId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{entityId}{(character) Data entity identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Size, in bytes, of \code{entityId} in \code{packageId}
}
\description{
Read data entity size
}
\examples{
\dontrun{

# List data entities
entityIds <- list_data_entities(packageId = "knb-lter-cdr.711.1")
entityIds
#> [1] "c61703839eac9a641ea0c3c69dc3345b"

# Read size
size <- read_data_entity_size(
 packageId = "knb-lter-cdr.711.1",
 entityId = entityIds
)
size
#> [1] 707094
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
