% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{check_subjid}
\alias{check_subjid}
\title{Check the completion of the subject ID column}
\usage{
check_subjid(x, ref = getOption("edc_subjid_ref"))
}
\arguments{
\item{x}{the subject ID column to check}

\item{ref}{the reference for subject ID. Should usually be set through \code{options(edc_subjid_ref=xxx)}. See example.}
}
\value{
nothing, called for warnings
}
\description{
Compare a subject ID vector to the study's reference subject ID (usually something like \code{enrolres$subjid}).
}
\examples{
tm = edc_example()
load_list(tm)
options(edc_subjid_ref=db0$SUBJID)
#usually, you set something like:
#options(edc_subjid_ref=enrolres$subjid)
check_subjid(db1$SUBJID)
check_subjid(db1$SUBJID \%>\% setdiff(2))
check_subjid(c(db1$SUBJID, 99))
}
