% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ChristoffersenBacktestForUnconditionalCoverage.R
\name{ChristoffersenBacktestForUnconditionalCoverage}
\alias{ChristoffersenBacktestForUnconditionalCoverage}
\title{Christoffersen Backtest for Unconditional Coverage}
\usage{
ChristoffersenBacktestForUnconditionalCoverage(Ra, Rb, cl)
}
\arguments{
\item{Ra}{Vector of portfolio profit and loss observations}

\item{Rb}{Vector of VaR forecasts corresponding to PandL observations}

\item{cl}{Confidence level for VaR}
}
\value{
Probability, given the data set, that the null hypothesis (i.e.
a correct model) is correct.
}
\description{
Carries out the Christiffersen backtest for unconditional coverage for a
VaR risk measurement model, for specified VaR confidence level.
}
\examples{
# Has to be modified with appropriate data:
   # Christoffersen Backtest For Unconditional Coverage for given parameters
   a <- rnorm(1*100)
   b <- abs(rnorm(1*100))+2
   ChristoffersenBacktestForUnconditionalCoverage(a, b, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Christoffersen, P. Evaluating interval forecasts. International Economic
Review, 39(4), 1998, 841-862.
}

