% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotfunctions.R
\name{responseplot.occu}
\alias{responseplot.occu}
\title{plot the response of an occupancy model to the change of aparticular variable}
\usage{
responseplot.occu(batch, spp, variable)
}
\arguments{
\item{batch}{A result from the batchoccu function.}

\item{spp}{The species number of which response is going to be ploted.}

\item{variable}{The variable of which the response is to be ploted.}
}
\value{
a ggplot object plotting the alpha diversity response to the selected
variable.
}
\description{
This function takes a batchoccupancy object and one of the variables used to
predict occupacy, and makes a plot showing the response of occupancyt against
the selected variable. This function automatically limits the values of that
variable to the maximum and minimum values of the dataset.
}
\examples{
\dontrun{
data("BatOccu")
data("Dailycov")
data("sampling.cov")
BatOccupancy <-batchoccu(pres = BatOccu, sitecov = sampling.cov,
obscov = Dailycov,spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum +
sdtemp ~ Burn.intensity.soil + I(Burn.intensity.soil^2) +
Burn.intensity.Canopy + I(Burn.intensity.Canopy^2) + Burn.intensity.basal +
I(Burn.intensity.basal^2))

#plot the response of occupancy to individual variables for species 4, 11
#and 15

responseplot.occu(batch = BatOccupancy, spp = 4, variable = Burn.intensity.soil)

responseplot.occu(batch = BatOccupancy, spp = 11, variable = Burn.intensity.soil)

responseplot.occu(batch = BatOccupancy, spp = 15, variable = Burn.intensity.soil)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{batchoccu}}
}

