% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVaR_binom.R
\name{TVaR_binom}
\alias{TVaR_binom}
\title{Tail Value-at-Risk of the Binomial distribution}
\usage{
TVaR_binom(kap, size, prob)
}
\arguments{
\item{kap}{probability.}

\item{size}{Number of trials (0 or more).}

\item{prob}{Probability of success on each trial.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_binom}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_binom}}}{ gives the expected value.}
 \item{\code{\link{V_binom}}}{ gives the variance.}
 \item{\code{\link{Etronq_binom}}}{ gives the truncated mean.}
 \item{\code{\link{TVaR_binom}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_binom}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Tail Value-at-Risk of the Binomial distribution with size
 \eqn{n}{n} and probability of success \eqn{p}{p}.
}
\details{
The Binomial distribution with probability of success \eqn{p}{p} for \eqn{n}{n} trials
  has probability mass function :
  \deqn{Pr(X = k) = \left(\frac{n}{k}\right) p^n (1 - p)^{n - k}}{Pr(X = k) = n!/(k!(n - k)!) p^n(1 - p)^(n - k)}
  for \eqn{k = 0, 1, 2, \dots, n}{k = 0, 1, 2, ..., n}, \eqn{p \in [0, 1]}{0 <= p <= 1}, and \eqn{n > 0}{n > 0}
}
\examples{

TVaR_binom(kap = 0.8, size = 5, prob = 0.2)

}
\seealso{
Other Binomial Distribution: 
\code{\link{E_binom}()},
\code{\link{Etronq_binom}()},
\code{\link{MGF_binom}()},
\code{\link{PGF_binom}()},
\code{\link{V_binom}()},
\code{\link{VaR_binom}()}
}
\concept{Binomial Distribution}
