% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kernel}
\alias{kernel}
\alias{kernel_DBH_fast}
\alias{kernel_DBH_crit}
\alias{kernel_ADBH_fast}
\alias{kernel_ADBH_crit}
\alias{kernel_DBR_fast}
\alias{kernel_DBR_crit}
\title{Kernel Functions}
\usage{
kernel_DBH_fast(
  pCDFlist,
  pvalues,
  stepUp = FALSE,
  tau_max = NULL,
  alpha = 0.05,
  support = numeric(),
  pCDFcounts = NULL
)

kernel_DBH_crit(
  pCDFlist,
  support,
  sorted_pv,
  stepUp = FALSE,
  alpha = 0.05,
  pCDFcounts = NULL
)

kernel_ADBH_fast(
  pCDFlist,
  sorted_pv,
  stepUp = FALSE,
  alpha = 0.05,
  support = numeric(),
  pCDFcounts = NULL
)

kernel_ADBH_crit(
  pCDFlist,
  support,
  sorted_pv,
  stepUp = FALSE,
  alpha = 0.05,
  pCDFcounts = NULL
)

kernel_DBR_fast(pCDFlist, sorted_pv, lambda = 0.05, pCDFcounts = NULL)

kernel_DBR_crit(
  pCDFlist,
  support,
  sorted_pv,
  lambda = 0.05,
  alpha = 0.05,
  pCDFcounts = NULL
)
}
\arguments{
\item{pCDFlist}{list of the supports of the CDFs of the p-values; each list item must be a numeric vector, which is sorted in increasing order and whose last element equals 1.}

\item{pvalues}{numeric vector, sorted in increasing order, that either
must contain the entirety of all observable values of
the p-value supports (when computing critical constants)
or only the sorted raw p-values.}

\item{stepUp}{boolean specifying whether to conduct the step-up
(\code{TRUE}) or step-down (\code{FALSE}; the default)
procedure.}

\item{tau_max}{single real number strictly between 0 and 1 indicating
the largest critical value for step-up procedures; if
\code{NULL} (the default), it is computed automatically,
otherwise it needs to be computed manually by the user;
ignored if \code{stepUp = FALSE}.}

\item{alpha}{single real number strictly between 0 and 1 indicating
the target FDR level; for \verb{*_fast} kernels, it is only
needed, if \code{stepUp = TRUE}.}

\item{support}{numeric vector, sorted in increasing order, that
contains the entirety of all observable values of the
p-value supports; for \verb{*_fast} kernels, it is ignored if
\code{stepUp = FALSE}.}

\item{pCDFcounts}{integer vector of counts that indicates to how many
p-values each \strong{unique} p-value distributions belongs.}

\item{sorted_pv}{numeric vector containing the raw p-values, sorted in
increasing order.}

\item{lambda}{real number strictly between 0 and 1 specifying the DBR
tuning parameter.}
}
\value{
For \code{kernel_DBH_fast()}, \code{kernel_ADBH_fast()} and \code{kernel_DBR_fast()}, a
vector of transformed p-values is returned. \code{kernel_DBH_crit},
\code{kernel_ADBH_crit} and \code{kernel_DBR_crit} return a list with critical
constants (\verb{$crit.consts}) and transformed p-values (\verb{$pval.transf}), but if
\code{stepUp = FALSE}, there are critical values only.
}
\description{
Kernel functions that transform observed p-values or their support according
to [HSU], [HSD], [AHSU], [AHSD] and [HBR-\eqn{\lambda}]. The
output is used by \link{discrete.BH} or \link{DBR}, respectively.
\code{kernel_DBH_crit}, \code{kernel_ADBH_crit} and \code{kernel_DBR_crit} additionally
compute and return the critical constants.
The end user should not use these functions directly.

\strong{Note}: As of version 2.0, these functions are purely internal functions!
As a consequence, they have to be called directly via \code{:::}, e.g.
\code{DiscreteFDR:::kernel_DBH_fast()}. But users should \strong{not} rely on them, as
parameters (including their names, order, etc.) may be changed without
notice!
}
\details{
When computing critical constants under step-down, that is, when using
\code{kernel_DBH_crit}, \code{kernel_ADBH_crit} or \code{kernel_DBR_crit} with
\code{stepUp = FALSE} (i.e. the step-down case), we still need to get transformed
p-values to compute the adjusted p-values.
}
\examples{
\dontrun{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
test.result <- generate.pvalues(df, "fisher")
raw.pvalues <- test.result$get_pvalues()
pCDFlist <- test.result$get_pvalue_supports()

alpha <- 0.05

# Compute the step functions from the supports

# If not searching for critical constants, we use only the observed p-values
sorted.pvals   <- sort(raw.pvalues)
y.DBH.sd.fast  <- DiscreteFDR:::kernel_DBH_fast(pCDFlist, sorted.pvals)
y.ADBH.sd.fast <- DiscreteFDR:::kernel_ADBH_fast(pCDFlist, sorted.pvals)
y.DBR.fast     <- DiscreteFDR:::kernel_DBR_fast(pCDFlist, sorted.pvals)
# transformed values
y.DBH.sd.fast
y.ADBH.sd.fast
y.DBR.fast

# compute transformed support
pv.list        <- sort(unique(unlist(pCDFlist)))
y.DBH.sd.crit  <- DiscreteFDR:::kernel_DBH_crit(pCDFlist, pv.list, sorted.pvals)
y.ADBH.sd.crit <- DiscreteFDR:::kernel_ADBH_crit(pCDFlist, pv.list, sorted.pvals)
y.DBR.crit     <- DiscreteFDR:::kernel_DBR_crit(pCDFlist, pv.list, sorted.pvals)
# critical constants
y.DBH.sd.crit$crit.consts
y.ADBH.sd.crit$crit.consts
y.DBR.crit$crit.consts
# The following exist only for step-down direction or DBR
y.DBH.sd.crit$pval.transf
y.ADBH.sd.crit$pval.transf
y.DBR.crit$pval.transf
}

}
\seealso{
\code{\link[=discrete.BH]{discrete.BH()}}, \code{\link[=direct.discrete.BH]{direct.discrete.BH()}}, \code{\link[=DBR]{DBR()}}
}
