% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere6.R
\name{sphere6}
\alias{sphere6}
\title{6D sphere function}
\usage{
sphere6(x)
}
\arguments{
\item{x}{a 6-dimensional vector specifying the location where the function
is to be evaluated.}
}
\value{
A real number equal to the sphere6 function values at \code{x}
}
\description{
6D Shifted and rotated weighted sphere test function.
}
\details{
The 6D Shifted and rotated weighted sphere (standardized version) function
is here defined over the domain \code{[0,1]^6}. It has 1 global minimizer :
x* = c(1,0.8,0.6,0.4,0.2,0), ), with minimum f(x*) = -1.941389. It has no
further local minima.
}
\examples{
 
design <- matrix(runif(400), 100, 4)
response <- apply(design, 1, sphere6)

}
\author{
Tobias Wagner  

Victor Picheny 

David Ginsbourger
}
\keyword{internal}
\keyword{optimize}
