% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_node_attrs.R
\name{mutate_node_attrs}
\alias{mutate_node_attrs}
\title{Mutate a set of node attribute values}
\usage{
mutate_node_attrs(graph, ...)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{...}{Expressions used for the mutation of node attributes. LHS of each
expression is either an existing or new node attribute name. The RHS can
consist of any valid R code that uses node attributes as variables.
Expressions are evaluated in the order provided, so, node attributes
created or modified are ready to use in subsequent expressions.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data frame (ndf), mutate numeric node
attribute values using one or more expressions.
}
\examples{
# Create a graph with 3 nodes
graph <-
  create_graph() \%>\%
  add_path(n = 3) \%>\%
  set_node_attrs(
    node_attr = width,
    values = c(1.4, 0.3, 1.1))

# Get the graph's internal ndf
# to show which node attributes
# are available
graph \%>\% get_node_df()

# Mutate the `width` node
# attribute, dividing each
# value by 2
graph <-
  graph \%>\%
  mutate_node_attrs(
    width = width / 2)

# Get the graph's internal
# ndf to show that the node
# attribute `width` had its
# values changed
graph \%>\% get_node_df()

# Create a new node attribute,
# called `length`, that is the
# log of values in `width` plus
# 2 (and, also, round all values
# to 2 decimal places)
graph <-
  graph \%>\%
  mutate_node_attrs(
    length = (log(width) + 2) \%>\%
               round(2))

# Get the graph's internal ndf
# to show that the node attribute
# values had been mutated
graph \%>\% get_node_df()

# Create a new node attribute
# called `area`, which is the
# product of the `width` and
# `length` attributes
graph <-
  graph \%>\%
  mutate_node_attrs(
    area = width * length)

# Get the graph's internal ndf
# to show that the node attribute
# values had been multiplied
# together (with new attr `area`)
graph \%>\% get_node_df()

}
