% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_data.R
\name{node_data}
\alias{node_data}
\title{Insert node data attributes during node creation}
\usage{
node_data(...)
}
\arguments{
\item{...}{node data attributes provided
as one or more named vectors.}
}
\description{
This helper function should be
invoked to provide values for the namesake
\code{node_data} argument, which is present
in any function where nodes are created.
}
\examples{
# Create a new graph and add
# a path with several node
# data attributes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    type = "path",
    node_data = node_data(
      hour = 5,
      index = c(1, 3, 2)))

# View the graph's internal
# node data frame; the node
# data attributes have been
# inserted
graph \%>\%
  get_node_df()
}
