% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_edge_direction.R
\name{reverse_edge_direction}
\alias{reverse_edge_direction}
\title{Reverse the graph's edge direction}
\usage{
reverse_edge_direction(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Take a directed graph and reverse the
edge directions.
}
\examples{
library(magrittr)

# Create a graph with a directed tree
graph <-
  create_graph() \%>\%
  add_balanced_tree(2, 2)

# Reverse the edge directions such that edges
# are directed toward the root of the tree
graph <-
  graph \%>\% reverse_edge_direction

# Inspect the graph's edges
graph \%>\% get_edges
#> [1] "2 -> 1" "3 -> 1" "4 -> 2" "5 -> 2" "6 -> 3"
#> [6] "7 -> 3"
}

