% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nbrs.R
\name{get_nbrs}
\alias{get_nbrs}
\title{Get all neighbors of one or more nodes}
\usage{
get_nbrs(graph, nodes)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{nodes}{a vector of node ID values.}
}
\value{
a vector of node ID values.
}
\description{
With one or more nodes, get the set of
all neighboring nodes.
}
\examples{
library(magrittr)

# Create a random, directed graph with 18 nodes
# and 22 edges
random_graph <-
  create_random_graph(
    n = 18,
    m = 22,
    directed = TRUE,
    fully_connected = TRUE,
    set_seed = 20) \%>\%
  set_global_graph_attrs(
    'graph', 'layout', 'sfdp') \%>\%
  set_global_graph_attrs(
    'graph', 'overlap', 'false')

# Find all neighbor nodes for node `5`
random_graph \%>\% get_nbrs(5)
#> [1] "1"  "2"  "12" "18"

# Find all neighbor nodes for nodes `5`, `7`,
# and `15`
random_graph \%>\% get_nbrs(c(5, 7, 15))
#> [1] "1"  "2"  "6"  "11" "12" "18"

# Get neighbors for node `11` and add a node
# attribute to color the nodes green, then, color
# all other nodes light gray
random_graph \%<>\%
  select_nodes_by_id(get_nbrs(., 11)) \%>\%
  set_node_attrs_ws('color', 'green') \%>\%
  invert_selection \%>\%
  set_node_attrs_ws('color', 'gray85') \%>\%
  clear_selection

# Render the graph to see the change
random_graph \%>\% render_graph
}

