% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_connected_components.R
\name{get_connected_components}
\alias{get_connected_components}
\title{Get all nodes associated with connected components}
\usage{
get_connected_components(graph, return_type = "df")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{return_type}{using \code{df} (the default), a
data frame containing the component ID and the nodes
associated with each connected component is
provided. With \code{list}, an anologous list object
is provided.}
}
\value{
a data frame or a list object, depending on
the value given to \code{return_type}.
}
\description{
Determine which nodes in a graph belong
to different connected components (i.e., distinct
sets of nodes with traversable paths to and from
each node in the set).
}
\examples{
\dontrun{
library(magrittr)

# Create a random graph
graph <-
  create_random_graph(36, 50, set_seed = 1)

# Check if the graph is connected
is_graph_connected(graph)
#> [1] TRUE

# Modify the graph so that it becomes disconnected
# (with two clusters of nodes)
graph <-
  graph \%>\%
  delete_edge(10, 36) \%>\%
  delete_edge(25, 27) \%>\%
  delete_edge(28, 29) \%>\%
  delete_edge(4, 29) \%>\%
  delete_edge(24, 32)

# Verify that the graph is disconnected
is_graph_connected(graph)
#> [1] FALSE

# Get the graph's connected components
get_connected_components(graph)
#>    component node
#> 1          1    1
#> 2          1    3
#> 3          1    4
#> 4          1    5
#> 5          1    6
#> 6          1    7
#> 7          1    8
#> 8          1    9
#> 9          1   11
#> 10         1   14
#> ..         ..  ..
}
}

