/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.ElementModel;
import edu.cens.spatial.plots.widgets.ParamSpatialVariable;
import edu.cens.spatial.plots.widgets.RPolyFunction;
import javax.swing.JDialog;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionDialog;

public class ChoroElementModel
extends ElementModel {
    RFunction rf;

    public ChoroElementModel() {
        this.init();
    }

    public void init() {
        this.rf = new RPolyFunction("choro_plot");
        this.rf.setViewType(null);
        ParamSpatialVariable paramSpatialVariable = new ParamSpatialVariable("dem");
        paramSpatialVariable.setFormat(ParamSpatialVariable.FORMAT_WITH_DATA);
        paramSpatialVariable.setTitle("Color");
        this.rf.add((Param)paramSpatialVariable);
        ParamNumeric paramNumeric = new ParamNumeric("alpha");
        paramNumeric.setTitle("Alpha");
        paramNumeric.setDefaultValue(0.5);
        paramNumeric.setLowerBound(0.0);
        paramNumeric.setUpperBound(1.0);
        paramNumeric.setValue(0.5);
        this.rf.add((Param)paramNumeric);
        ParamCharacter paramCharacter = new ParamCharacter("legend.loc");
        paramCharacter.setTitle("Legend location");
        paramCharacter.setOptions(new String[]{"bottomleft", "bottomright", "topleft", "topright"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue((Object)"bottomleft");
        paramCharacter.setValue((Object)"bottomleft");
        this.rf.add((Param)paramCharacter);
        paramCharacter = new ParamCharacter("legend.title");
        paramCharacter.setTitle("Legend title");
        this.rf.add((Param)paramCharacter);
        this.iconLocation = "icons/geo_choropleth.png";
        this.name = "Choropleth";
    }

    public JDialog getView() {
        RFunctionDialog rFunctionDialog = new RFunctionDialog(this.rf);
        rFunctionDialog.setSize(500, 400);
        rFunctionDialog.setRun(false);
        return rFunctionDialog;
    }

    public String getCall() {
        return this.rf.getCall();
    }

    public String checkValid() {
        return this.rf.checkValid();
    }

    public ChoroElementModel clone() {
        ChoroElementModel choroElementModel = new ChoroElementModel();
        choroElementModel.rf = (RFunction)this.rf.clone();
        return choroElementModel;
    }

    public String getDataFrameArgumentName() {
        return ((ParamSpatialVariable)this.rf.get(0)).getData();
    }

    public void setDataFrameArgumentName(String string) {
        this.rf.get(0).setValue((Object)string);
    }
}

