/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarSet;

class LoaderDelphiFilter {
    static final int VT_unknown = 0;
    static final int VT_known = 1;
    static final int VT_num = 2;
    static final int VT_cat = 4;
    static final int VT_miss = 8;
    SVarSet vs;
    int[] vt;
    int rows = -1;

    LoaderDelphiFilter(SVarSet sVarSet) {
        this.vs = sVarSet;
        this.vt = new int[sVarSet.count()];
    }

    void nextRecord() {
        ++this.rows;
    }

    void addValue(int n, String string, int n2) {
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (string != null && string.equals("NA")) {
            string = null;
        }
        if (n < 0 || n >= this.vt.length) {
            System.out.println("Loader, line " + n2 + ": column " + (n + 1) + " has no header, dropping.");
            return;
        }
        SVar sVar = this.vs.at(n);
        if (sVar == null) {
            System.out.println("Loader, line " + n2 + ": variable for column " + (n + 1) + " is null.");
            return;
        }
        int n3 = sVar.size();
        if (n3 < this.rows) {
            System.out.println("Loader, line " + n2 + ": previous rows are missing (" + (this.rows - n3) + "), filling with missings.");
            while (n3 < this.rows) {
                sVar.add(null);
                ++n3;
            }
        }
        if (this.rows < n3) {
            System.out.println("Loader, line " + n2 + ": FATAL! The variable " + sVar.getName() + " has already " + n3 + " entries, but this is the entry " + this.rows + "!");
            return;
        }
        if (this.vt[n] == 0) {
            if (string == null) {
                sVar.add(null);
                return;
            }
            try {
                Double d = Double.valueOf(string);
                int n4 = n;
                this.vt[n4] = this.vt[n4] | 3;
                sVar.add(d);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                sVar.add(string);
                sVar.categorize();
                int n5 = n;
                this.vt[n5] = this.vt[n5] | 5;
            }
        } else {
            if ((this.vt[n] & 2) > 0) {
                try {
                    Double d = Double.valueOf(string);
                    sVar.add(d);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Loader, line " + n2 + ", column " + (n + 1) + ": expected numerical value, found \"" + string + "\"; treating as missing.");
                    sVar.add(null);
                    return;
                }
            }
            sVar.add(string);
        }
    }
}

