/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.rosuda.deducer.widgets.param.RFunctionList;
import org.rosuda.deducer.widgets.param.RFunctionListPanelWidget;

public class RFunctionListDialog
extends JDialog
implements ActionListener {
    private JPanel panel;
    private OkayCancelPanel okayCancel;
    private HelpButton help;
    private ParamWidget view;
    private RFunctionList initialModel;
    private RFunctionList model;
    private VariableSelectorWidget selector;
    private JScrollPane scroller;
    private Param[] globalParams = new Param[0];
    private boolean isRun = true;

    public RFunctionListDialog(JFrame jFrame, RFunctionList rFunctionList) {
        super(jFrame);
        try {
            this.initGUI();
            this.setModel(rFunctionList);
            this.setRun(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RFunctionListDialog(RFunctionList rFunctionList) {
        try {
            this.initGUI();
            this.setModel(rFunctionList);
            this.setRun(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("");
            this.add((Component)this.help, new AnchorConstraint(923, 92, 12, 12, 0, 0, 2, 2));
            this.help.setPreferredSize(new Dimension(29, 26));
            this.help.setVisible(false);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.add((Component)this.okayCancel, new AnchorConstraint(923, 21, 0, 521, 0, 2, 2, 0));
            this.okayCancel.setPreferredSize(new Dimension(195, 38));
            this.panel = new JPanel();
            this.scroller = new JScrollPane();
            this.scroller.setHorizontalScrollBarPolicy(31);
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            this.scroller.setBorder(border);
            this.scroller.setViewportView(this.panel);
            if (this.selector == null) {
                this.selector = new VariableSelectorWidget();
                this.selector.setPreferredSize(new Dimension(150, 300));
            }
            this.setSize(450, 515);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(RFunctionList rFunctionList) {
        RFunctionListPanelWidget rFunctionListPanelWidget;
        if (this.globalParams == null || this.globalParams.length == 0) {
            if (rFunctionList.requiresVariableSelector()) {
                this.view = rFunctionList.getView(this.selector);
                this.panel = this.view;
            } else {
                this.view = rFunctionList.getView();
                this.panel = this.view;
            }
        } else if (rFunctionList.requiresVariableSelector()) {
            rFunctionListPanelWidget = new RFunctionListPanelWidget(rFunctionList, this.selector);
            this.view = rFunctionListPanelWidget;
            this.panel = this.view;
        } else {
            rFunctionListPanelWidget = new RFunctionListPanelWidget(rFunctionList);
            this.view = rFunctionListPanelWidget;
            this.panel = this.view;
        }
        this.scroller.setViewportView(this.panel);
        this.initialModel = (RFunctionList)rFunctionList.clone();
        this.model = rFunctionList;
        this.setTitle(rFunctionList.getName());
        this.remove(this.scroller);
        boolean bl = this.model.requiresVariableSelector();
        if (bl) {
            this.add((Component)this.scroller, new AnchorConstraint(60, 10, 50, 170, 2, 2, 2, 2));
            this.add((Component)this.selector, new AnchorConstraint(20, 90, 50, 10, 2, 0, 2, 2));
        } else {
            this.remove(this.scroller);
            if (this.selector != null) {
                this.remove(this.selector);
            }
            this.add((Component)this.scroller, new AnchorConstraint(60, 1000, 50, 1, 2, 1, 2, 2));
        }
        this.validate();
        this.repaint();
    }

    public void setToInitialModel() {
        RFunctionList rFunctionList = (RFunctionList)this.initialModel.clone();
        this.setModel(rFunctionList);
    }

    public void run() {
        try {
            if (this.selector != null) {
                this.selector.refreshDataNames();
                this.selector.setSelectedData(this.selector.getSelectedData());
            }
            if (this.initialModel != null) {
                this.setToInitialModel();
            }
            this.setVisible(true);
            if (!Deducer.isJGR()) {
                WindowTracker.addWindow(this);
                WindowTracker.waitForAllClosed();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            this.view.updateModel();
            String string2 = this.model.checkValid();
            if (string2 != null) {
                JOptionPane.showMessageDialog(this, string2);
            } else {
                this.initialModel = (RFunctionList)this.model.clone();
                this.setVisible(false);
            }
        } else if (string == "Cancel") {
            this.setToInitialModel();
            this.setVisible(false);
        } else if (string == "Run") {
            this.view.updateModel();
            String string3 = this.model.checkValid();
            if (string3 != null) {
                JOptionPane.showMessageDialog(this, string3);
            } else {
                this.initialModel = (RFunctionList)this.model.clone();
                this.setVisible(false);
                Deducer.execute(this.model.getCall());
            }
        }
    }

    private HelpButton getHelpButton() {
        return this.help;
    }

    public void setRun(boolean bl) {
        if (bl) {
            this.okayCancel.getApproveButton().setText("Run");
        } else {
            this.okayCancel.getApproveButton().setText("OK");
        }
        this.isRun = bl;
    }

    public boolean isRun() {
        return this.isRun;
    }
}

