/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Color;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.Deducer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Aes {
    public static final String DATA_ANY = "any";
    public static final String DATA_NONE = "none";
    public static final String DATA_NUMERIC = "numeric";
    public static final String DATA_COLOUR = "col";
    public static final String DATA_LINE = "ln";
    public static final String DATA_SHAPE = "shape";
    public static final String DATA_NUMERIC_BOUNDED = "bounded";
    public boolean preferNumeric = false;
    public boolean preferCategorical = false;
    public String name;
    public String title;
    public String variable;
    public String defaultVariable;
    public Object value;
    public Object defaultValue;
    public boolean required = false;
    public boolean defaultUseVariable = false;
    public boolean useVariable;
    public String dataType;
    public Double lowerBound;
    public Double upperBound;

    public Object clone() {
        Aes aes = new Aes();
        aes.name = this.name;
        aes.title = this.title;
        aes.variable = this.variable;
        aes.defaultVariable = this.defaultVariable;
        aes.required = this.required;
        aes.defaultUseVariable = this.defaultUseVariable;
        aes.useVariable = this.useVariable;
        aes.dataType = this.dataType;
        aes.preferCategorical = this.preferCategorical;
        aes.preferNumeric = this.preferNumeric;
        if (this.lowerBound != null) {
            aes.lowerBound = new Double(this.lowerBound);
        }
        if (this.upperBound != null) {
            aes.upperBound = new Double(this.upperBound);
        }
        if (this.dataType.equals(DATA_NUMERIC) || this.dataType.equals(DATA_NUMERIC_BOUNDED)) {
            if (this.value != null) {
                aes.value = new Double((Double)this.value);
            }
            if (this.defaultValue != null) {
                aes.defaultValue = new Double((Double)this.defaultValue);
            }
        } else if (this.dataType.equals(DATA_SHAPE) || this.dataType.equals(DATA_LINE)) {
            if (this.value != null) {
                aes.value = new Integer((Integer)this.value);
            }
            if (this.defaultValue != null) {
                aes.defaultValue = new Integer((Integer)this.defaultValue);
            }
        } else if (this.dataType.equals(DATA_COLOUR)) {
            Color color;
            if (this.value != null) {
                color = (Color)this.value;
                aes.value = new Color(color.getRGB());
            }
            if (this.defaultValue != null) {
                color = (Color)this.defaultValue;
                aes.defaultValue = new Color(color.getRGB());
            }
        } else {
            aes.value = this.value;
            aes.defaultValue = this.defaultValue;
        }
        return aes;
    }

    public String[] getAesCalls() {
        boolean bl = this.useVariable || this.value == null;
        String[] stringArray = this.variable != null && this.variable.length() > 0 && this.variable != this.defaultVariable && bl ? new String[]{this.name + " = " + this.variable} : new String[]{};
        return stringArray;
    }

    public String[] getParamCalls() {
        String[] stringArray;
        boolean bl;
        boolean bl2 = bl = this.useVariable && this.variable != null && this.variable.length() > 0;
        if (this.value != null && !this.value.equals(this.defaultValue) && !bl) {
            String string;
            if (this.value instanceof Color) {
                string = "'#" + Integer.toHexString(((Color)this.value).getRGB()).substring(2) + "'";
            } else if (this.dataType == DATA_ANY && this.value.toString().length() > 0) {
                try {
                    Double.parseDouble(this.value.toString());
                    string = this.value.toString();
                }
                catch (Exception exception) {
                    string = "'" + Deducer.addSlashes(this.value.toString()) + "'";
                }
            } else {
                string = this.value.toString();
            }
            stringArray = string.length() > 0 ? new String[]{this.name + " = " + string} : new String[]{};
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static Aes makeAes(String string) {
        Aes aes = new Aes();
        aes.name = string;
        String string2 = string.substring(1);
        aes.title = string.substring(0, 1).toUpperCase().concat(string2);
        if (string.equals("x")) {
            aes.dataType = DATA_ANY;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("y")) {
            aes.dataType = DATA_ANY;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("z")) {
            aes.dataType = DATA_ANY;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("colour")) {
            aes.dataType = DATA_COLOUR;
        } else if (string.equals("fill")) {
            aes.dataType = DATA_COLOUR;
        } else if (string.equals("label")) {
            aes.dataType = DATA_ANY;
        } else if (string.equals("size")) {
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.defaultValue = new Double(0.5);
            aes.lowerBound = new Double(0.0);
        } else if (string.equals("alpha")) {
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.defaultValue = new Double(1.0);
            aes.lowerBound = new Double(0.0);
            aes.upperBound = new Double(1.0);
            aes.defaultUseVariable = false;
            aes.title = "Alpha";
            aes.preferNumeric = true;
        } else if (string.equals("angle")) {
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.defaultValue = new Double(0.0);
            aes.lowerBound = new Double(0.0);
            aes.upperBound = new Double(360.0);
        } else if (string.equals("radius")) {
            aes.required = true;
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.lowerBound = new Double(0.0);
        } else if (string.equals("hjust")) {
            aes.name = "hjust";
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.lowerBound = new Double(0.0);
            aes.upperBound = new Double(1.0);
            aes.defaultValue = new Double(0.5);
            aes.defaultUseVariable = false;
        } else if (string.equals("vjust")) {
            aes.name = "vjust";
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.lowerBound = new Double(0.0);
            aes.upperBound = new Double(1.0);
            aes.defaultValue = new Double(0.5);
            aes.defaultUseVariable = false;
        } else if (string.equals("intercept")) {
            aes.dataType = DATA_NUMERIC;
        } else if (string.equals("xintercept")) {
            aes.dataType = DATA_NUMERIC;
        } else if (string.equals("yintercept")) {
            aes.dataType = DATA_NUMERIC;
        } else if (string.equals("slope")) {
            aes.dataType = DATA_NUMERIC;
        } else if (string.equals("linetype")) {
            aes.dataType = DATA_LINE;
            aes.defaultValue = new Integer(1);
            aes.title = "Line";
            aes.preferCategorical = true;
        } else if (string.equals("size")) {
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.lowerBound = new Double(0.0);
        } else if (string.equals("xmin")) {
            aes.dataType = DATA_NUMERIC;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("xmax")) {
            aes.dataType = DATA_NUMERIC;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("ymin")) {
            aes.dataType = DATA_NUMERIC;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("ymax")) {
            aes.dataType = DATA_NUMERIC;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals("weight")) {
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.lowerBound = new Double(0.0);
            aes.defaultValue = new Double(1.0);
        } else if (string.equals("lower")) {
            aes.dataType = DATA_NONE;
        } else if (string.equals("upper")) {
            aes.dataType = DATA_NONE;
        } else if (string.equals("middle")) {
            aes.dataType = DATA_NONE;
        } else if (string.equals("width")) {
            aes.dataType = DATA_NUMERIC_BOUNDED;
            aes.lowerBound = new Double(0.0);
            aes.defaultValue = new Double(0.5);
        } else if (string.equals("sample")) {
            aes.dataType = DATA_NONE;
            aes.required = true;
            aes.defaultUseVariable = true;
        } else if (string.equals(DATA_SHAPE)) {
            aes.dataType = DATA_SHAPE;
            aes.defaultValue = new Integer(16);
            aes.preferCategorical = true;
        } else if (string.equals("xend")) {
            aes.dataType = DATA_ANY;
            aes.defaultUseVariable = true;
        } else if (string.equals("yend")) {
            aes.dataType = DATA_ANY;
            aes.defaultUseVariable = true;
        } else {
            aes.dataType = string.equals("group") ? DATA_NONE : DATA_NONE;
        }
        aes.value = aes.defaultValue;
        aes.variable = aes.defaultVariable;
        aes.useVariable = aes.defaultUseVariable;
        return aes;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("Aes");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.title != null) {
                element.setAttribute("title", this.title);
            }
            if (this.dataType != null) {
                element.setAttribute("dataType", this.dataType);
            }
            if (this.lowerBound != null) {
                element.setAttribute("lowerBound", this.lowerBound.toString());
            }
            if (this.upperBound != null) {
                element.setAttribute("upperBound", this.upperBound.toString());
            }
            element.setAttribute("useVariable", this.useVariable ? "true" : "false");
            element.setAttribute("defaultUseVariable", this.defaultUseVariable ? "true" : "false");
            element.setAttribute("required", this.required ? "true" : "false");
            element.setAttribute("preferNumeric", this.preferNumeric ? "true" : "false");
            element.setAttribute("preferCategorical", this.preferCategorical ? "true" : "false");
            if (this.variable != null) {
                element.setAttribute("variable", this.variable);
            }
            if (this.defaultVariable != null) {
                element.setAttribute("defaultVariable", this.defaultVariable);
            }
            if (this.value instanceof String) {
                element.setAttribute("value", this.value.toString());
            } else if (this.value instanceof Double || this.value instanceof Integer) {
                element.setAttribute("value", this.value.toString());
            } else if (this.value instanceof Color) {
                element.setAttribute("value", "#" + Integer.toHexString(((Color)this.value).getRGB()).substring(2));
            }
            if (this.defaultValue instanceof String) {
                element.setAttribute("defaultValue", this.defaultValue.toString());
            } else if (this.defaultValue instanceof Double || this.defaultValue instanceof Integer) {
                element.setAttribute("defaultValue", this.defaultValue.toString());
            } else if (this.defaultValue instanceof Color) {
                element.setAttribute("defaultValue", "#" + Integer.toHexString(((Color)this.defaultValue).getRGB()).substring(2));
            }
            element.setAttribute("className", "Aes");
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.title = element.hasAttribute("title") ? element.getAttribute("title") : null;
        this.dataType = element.hasAttribute("dataType") ? element.getAttribute("dataType") : null;
        this.lowerBound = element.hasAttribute("lowerBound") ? new Double(Double.parseDouble(element.getAttribute("lowerBound"))) : null;
        this.upperBound = element.hasAttribute("upperBound") ? new Double(Double.parseDouble(element.getAttribute("upperBound"))) : null;
        this.useVariable = element.hasAttribute("useVariable") ? element.getAttribute("useVariable").equals("true") : false;
        this.preferNumeric = element.hasAttribute("preferNumeric") ? element.getAttribute("preferNumeric").equals("true") : false;
        this.preferCategorical = element.hasAttribute("preferCategorical") ? element.getAttribute("preferCategorical").equals("true") : false;
        this.defaultUseVariable = element.hasAttribute("defaultUseVariable") ? element.getAttribute("defaultUseVariable").equals("true") : false;
        this.required = element.hasAttribute("required") ? element.getAttribute("required").equals("true") : false;
        this.variable = element.hasAttribute("variable") ? element.getAttribute("variable") : null;
        this.defaultVariable = element.hasAttribute("defaultVariable") ? element.getAttribute("defaultVariable") : null;
        if (element.hasAttribute("value")) {
            this.value = this.dataType.equals(DATA_NUMERIC) || this.dataType.equals(DATA_NUMERIC_BOUNDED) ? new Double(Double.parseDouble(element.getAttribute("value"))) : (this.dataType.equals(DATA_SHAPE) || this.dataType.equals(DATA_LINE) ? new Integer(Integer.parseInt(element.getAttribute("value"))) : (this.dataType.equals(DATA_COLOUR) ? Color.decode(element.getAttribute("value")) : element.getAttribute("value")));
        }
        if (element.hasAttribute("defaultValue")) {
            this.defaultValue = this.dataType.equals(DATA_NUMERIC) || this.dataType.equals(DATA_NUMERIC_BOUNDED) ? new Double(Double.parseDouble(element.getAttribute("defaultValue"))) : (this.dataType.equals(DATA_SHAPE) || this.dataType.equals(DATA_LINE) ? new Integer(Integer.parseInt(element.getAttribute("defaultValue"))) : (this.dataType.equals(DATA_COLOUR) ? Color.decode(element.getAttribute("defaultValue")) : element.getAttribute("defaultValue")));
        }
    }

    public static Aes makeAes(String string, Object object, String string2) {
        Aes aes = Aes.makeAes(string);
        if (object != null) {
            aes.defaultUseVariable = false;
            aes.useVariable = false;
            aes.value = object;
            aes.defaultValue = object;
        }
        if (string2 != null) {
            aes.defaultUseVariable = true;
            aes.useVariable = true;
            aes.variable = string2;
            aes.defaultVariable = string2;
        }
        return aes;
    }
}

