/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu.twosample;

import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.OneWayPlotModel;
import org.rosuda.deducer.menu.SubsetDialog;

public class TwoSampleModel {
    public String dataName = null;
    public DefaultListModel variables = new DefaultListModel();
    public DefaultListModel factorName = new DefaultListModel();
    public String subset = "";
    public boolean doT = true;
    public boolean doBoot = false;
    public boolean doKS = false;
    public boolean doMW = false;
    public boolean doBM = false;
    public boolean tEqVar = false;
    public String bootStat = "t";
    public OptionsModel optMod = new OptionsModel();
    public SplitModel splitMod = new SplitModel();
    public OneWayPlotModel plots = new OneWayPlotModel();

    public boolean run() {
        String string;
        String string2;
        if (this.dataName == null) {
            return false;
        }
        if (this.variables.size() == 0) {
            JOptionPane.showMessageDialog(null, "Please select one or more outcome variables.");
            return false;
        }
        if (this.factorName.size() == 0) {
            JOptionPane.showMessageDialog(null, "Please select a factor.");
            return false;
        }
        this.subset = this.subset.trim();
        String string3 = "";
        String string4 = Deducer.makeRCollection(this.variables, "d", false);
        String string5 = this.splitMod.dich((String)this.factorName.get(0));
        boolean bl = false;
        if (!this.subset.equals("")) {
            if (!SubsetDialog.isValidSubsetExp(this.subset, this.dataName)) {
                JOptionPane.showMessageDialog(null, "Sorry, the subset expression seems to be invalid.");
                return false;
            }
            string2 = Deducer.getUniqueName(this.dataName + ".sub");
            string3 = string2 + "<-subset(" + this.dataName + "," + this.subset + ")" + "\n";
            bl = true;
        } else {
            string2 = this.dataName;
        }
        if (this.optMod.descriptives) {
            string3 = string3 + "descriptive.table(" + string4 + "," + string5 + "," + string2 + ",func.names =c(\"Mean\",\"St. Deviation\",\"Valid N\"))\n";
        }
        if (this.doT) {
            string3 = string3 + "print(two.sample.test(formula=" + string4 + " ~ " + string5 + ",\n\t\tdata=" + string2 + ",\n\t\ttest=t.test" + (this.tEqVar ? ",\n\t\tvar.equal=TRUE" : "") + (this.optMod.confLevel == 0.95 ? "" : ",\n\t\tconf.level=" + this.optMod.confLevel) + ",\n\t\talternative=\"" + this.optMod.alternative + "\"" + ")" + (this.optMod.digits.trim().equals("<auto>") ? "\n)" : ",\n\tdigits=" + this.optMod.digits + ")") + "\n";
        }
        if (this.doMW) {
            string3 = string3 + "print(two.sample.test(formula=" + string4 + " ~ " + string5 + ",\n\t\tdata=" + string2 + ",\n\t\ttest=wilcox.test" + (this.optMod.confLevel == 0.95 ? "" : ",\n\t\tconf.level=" + this.optMod.confLevel) + ",\n\t\talternative=\"" + this.optMod.alternative + "\"" + ",\n\t\t correct=FALSE" + ")" + (this.optMod.digits.trim().equals("<auto>") ? "\n)" : ",\n\tdigits=" + this.optMod.digits + ")") + "\n";
        }
        if (this.doBoot) {
            string3 = string3 + "print(two.sample.test(formula=" + string4 + " ~ " + string5 + ",\n\t\tdata=" + string2 + ",\n\t\ttest=perm.t.test" + (this.optMod.confLevel == 0.95 ? "" : ",\n\t\tconf.level=" + this.optMod.confLevel) + ",\n\t\talternative=\"" + this.optMod.alternative + "\"" + ",\n\t\tstatistic='" + this.bootStat + "'" + ")" + (this.optMod.digits.trim().equals("<auto>") ? "\n)" : ",\n\tdigits=" + this.optMod.digits + ")") + "\n";
        }
        if (this.doKS) {
            string3 = string3 + "print(two.sample.test(formula=" + string4 + " ~ " + string5 + ",\n\t\tdata=" + string2 + ",\n\t\ttest=ks.test" + (this.optMod.confLevel == 0.95 ? "" : ",\n\t\tconf.level=" + this.optMod.confLevel) + ",\n\t\talternative=\"" + this.optMod.alternative + "\"" + ")" + (this.optMod.digits.trim().equals("<auto>") ? "\n)" : ",\n\tdigits=" + this.optMod.digits + ")") + "\n";
        }
        if (this.doBM) {
            string = Deducer.requirePackage("lawstat");
            if (string == "not-installed") {
                JOptionPane.showMessageDialog(null, "Package lawstat must be installed in order to do the Brunner-Munszel test");
                return false;
            }
            if (string == "installed") {
                string3 = string3 + "library(lawstat)\n";
            }
            string3 = string3 + "print(two.sample.test(formula=" + string4 + " ~ " + string5 + ",\n\t\tdata=" + string2 + ",\n\t\ttest=brunner.munzel.test" + (this.optMod.confLevel == 0.95 ? "" : ",\n\t\tconf.level=" + this.optMod.confLevel) + ",\n\t\talternative=\"" + this.optMod.alternative + "\"" + ")" + (this.optMod.digits.trim().equals("<auto>") ? "\n)" : ",\n\tdigits=" + this.optMod.digits + ")") + "\n";
        }
        if (this.plots.plot) {
            string = string2;
            if (this.splitMod.group1.size() > 0 || this.splitMod.group2.size() > 0 || this.splitMod.isCut) {
                string = string2;
            }
            string3 = string3 + this.plots.getCmd(string, string4, string5);
        }
        if (bl) {
            string3 = string3 + "rm(" + string2 + ")\n";
        }
        Deducer.execute(string3);
        return true;
    }

    public class SplitModel {
        public boolean isCut = false;
        public String cutPoint = "";
        public Vector group1 = new Vector();
        public Vector group2 = new Vector();

        public String getFactorName() {
            if (TwoSampleModel.this.factorName.size() > 0) {
                return (String)TwoSampleModel.this.factorName.firstElement();
            }
            return null;
        }

        public String getDataName() {
            return TwoSampleModel.this.dataName;
        }

        public String dich(String string) {
            if (this.isCut) {
                String string2;
                try {
                    Double.parseDouble(TwoSampleModel.this.splitMod.cutPoint);
                    string2 = TwoSampleModel.this.splitMod.cutPoint;
                }
                catch (Exception exception) {
                    string2 = "\"" + TwoSampleModel.this.splitMod.cutPoint + "\"";
                }
                return "dich(" + string + ",cut=" + string2 + ")";
            }
            if (this.group1.size() != 0 || this.group2.size() != 0) {
                return "dich(" + string + (this.group1.size() > 0 ? ",group1=" + Deducer.makeRCollection(this.group1, "c", true) : "") + (this.group2.size() > 0 ? ",group2=" + Deducer.makeRCollection(this.group2, "c", true) : "") + ")";
            }
            return string;
        }
    }

    public class OptionsModel {
        public boolean descriptives = true;
        public String digits = "<auto>";
        public String alternative = "two.sided";
        public double confLevel = 0.95;
    }
}

