% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.r
\name{find.smooth.tau}
\alias{find.smooth.tau}
\title{Find best order of the samples assuming some smooth GP prior on the
expression profiles over this ordering.}
\usage{
find.smooth.tau(dl, psi = exp(dl$hyper$mu_psi),
  omega = exp(dl$hyper$mu_omega), num.cores = default.num.cores(),
  num.tau.to.try = num.cores, num.tau.to.keep = num.cores,
  method = "metropolis", ...)
}
\arguments{
\item{dl}{de.lorean object}

\item{psi}{Temporal variation}

\item{omega}{Noise}

\item{num.cores}{Number of cores to run on. Defaults to default.num.cores()}

\item{num.tau.to.try}{How many initialisations to try}

\item{num.tau.to.keep}{How many initialisations to keep}

\item{method}{Method to use "maximise" or "metropolis"}

\item{...}{Extra arguments to method}
}
\description{
Find best order of the samples assuming some smooth GP prior on the
expression profiles over this ordering.
}
