% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.r
\name{estimate.hyper}
\alias{estimate.hyper}
\title{Estimate hyperparameters for model using empirical Bayes.}
\usage{
estimate.hyper(dl, sigma.tau = 0.5, length.scale = NULL,
  model.name = "exact", adjust.cell.sizes = TRUE)
}
\arguments{
\item{dl}{de.lorean object}

\item{sigma.tau}{Noise s.d. in temporal dimension, that is prior s.d. for tau}

\item{length.scale}{Length scale for stationary GP covariance function.
Defaults to the range of the observed capture times.}

\item{model.name}{The model's name:
\itemize{
  \item 'exact': The model without a low rank approximation
    that does not estimate the cell sizes.
  \item 'exact-sizes': The model without a low rank approximation
    that does estimate the cell sizes.
  \item 'lowrank': Low rank approximation to the 'exact' model.
  \item 'lowrank-sizes': Low rank approximation to the 'exact-sizes' model.
}}

\item{adjust.cell.sizes}{Adjust by the cell sizes for better estimates of the hyperparameters}
}
\description{
Estimate hyperparameters for model using empirical Bayes.
}

