/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.Logger;
import net.starschema.clouddb.jdbc.list.CallContainer;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.SourceTable;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;

public class Resolver {
    Connection connection;
    TreeBuilder builder;
    CallContainer container;
    protected Logger logger = Logger.getLogger(this.getClass());

    public Resolver(TreeBuilder builder) {
        this.connection = builder.getConnection();
        this.builder = builder;
        this.container = builder.callContainer;
    }

    protected List<ColumnCall> parseSrcTableForJokers(SourceTable sourceTable) {
        ArrayList<ColumnCall> returnlist = new ArrayList<ColumnCall>();
        List<String> columnstrings = this.builder.GetColumns(sourceTable);
        for (String string : columnstrings) {
            ColumnCall columnforreturn = new ColumnCall(null, null, this.builder, string, null);
            returnlist.add(columnforreturn);
        }
        return returnlist;
    }

    protected List<ColumnCall> parseSubQForJokers(SubQuery subQuery) {
        ArrayList<ColumnCall> returnlist = new ArrayList<ColumnCall>();
        this.logger.debug("GETTING EXPRESSION");
        Expression expression = subQuery.getSelectStatement().getExpression();
        if (expression != null) {
            this.logger.debug("EXPRESSION is NOT NULL");
            this.logger.debug(expression.toPrettyString());
        }
        List<ColumnCall> columns = expression.getColumns();
        List<FunctionCall> functionCalls = expression.getFunctionCalls();
        if (functionCalls != null) {
            this.logger.debug("HAS FUNCTIONCALLS");
            for (FunctionCall functionCall : functionCalls) {
                returnlist.add(new ColumnCall(new String[]{subQuery.getUniqueId()}, null, this.builder, functionCall.getAlias(), functionCall, null));
            }
        }
        if (columns != null) {
            this.logger.debug("HAS COLUMNS");
            for (ColumnCall column : columns) {
                ColumnCall returncolumn;
                if (column.getAlias() != null) {
                    returncolumn = new ColumnCall(null, null, this.builder, column.getAlias(), column, null);
                    returncolumn.addPrefixtoFront(subQuery.getAlias());
                    returnlist.add(returncolumn);
                    continue;
                }
                returncolumn = new ColumnCall(null, null, this.builder, column.getName(), column, null);
                returncolumn.addPrefixtoFront(subQuery.getAlias());
                returnlist.add(returncolumn);
            }
        }
        return returnlist;
    }
}

